/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCPassport;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.message.MessageType;
import io.github.dsheirer.module.decode.passport.PassportBand;
import io.github.dsheirer.module.decode.passport.identifier.PassportRadioId;
import io.github.dsheirer.module.decode.passport.identifier.PassportTalkgroup;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PassportMessage
extends Message {
    private static final int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] DIGITAL_COLOR_CODE = new int[]{9, 10};
    private static final int[] CHANNEL_NUMBER = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private static final int[] SITE = new int[]{22, 23, 24, 25, 26, 27, 28};
    private static final int[] GROUP = new int[]{29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] RADIO_ID = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] NEIGHBOR_BAND = new int[]{33, 34, 35, 36};
    private static final int[] SITE_BAND = new int[]{41, 42, 43, 44};
    private static final int[] TYPE = new int[]{45, 46, 47, 48};
    private static final int[] FREE = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
    private static final int[] CHECKSUM = new int[]{60, 61, 62, 63, 64, 65, 66, 67};
    private CorrectedBinaryMessage mMessage;
    private CRC mCRC;
    private PassportMessage mIdleMessage;
    private PassportRadioId mFromIdentifier;
    private PassportTalkgroup mToIdentifier;
    private List<Identifier> mIdentifiers;

    public PassportMessage(CorrectedBinaryMessage message, PassportMessage idleMessage) {
        this.mMessage = CRCPassport.correct(message);
        this.mIdleMessage = idleMessage;
        this.mCRC = CRCPassport.check(this.mMessage);
    }

    public PassportMessage(CorrectedBinaryMessage message) {
        this(message, null);
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public PassportTalkgroup getToIdentifier() {
        if (this.mToIdentifier == null) {
            this.mToIdentifier = PassportTalkgroup.create(this.getMessage().getInt(GROUP));
        }
        return this.mToIdentifier;
    }

    public PassportRadioId getFromIdentifier() {
        if (this.mFromIdentifier == null) {
            this.mFromIdentifier = PassportRadioId.create(this.getMessage().getInt(RADIO_ID));
        }
        return this.mFromIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasFromIdentifier()) {
                this.mIdentifiers.add(this.getFromIdentifier());
            }
            if (this.hasToIdentifier()) {
                this.mIdentifiers.add(this.getToIdentifier());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public boolean isValid() {
        return this.mCRC.passes();
    }

    public CRC getCRC() {
        return this.mCRC;
    }

    public MessageType getMessageType() {
        MessageType retVal = MessageType.UN_KNWN;
        int type = this.getMessageTypeNumber();
        int lcn = this.getLCN();
        switch (type) {
            case 0: {
                retVal = MessageType.CA_STRT;
                break;
            }
            case 1: {
                if (this.getFree() == 2042) {
                    retVal = MessageType.ID_TGAS;
                    break;
                }
                if (lcn < 1792) {
                    retVal = MessageType.CA_STRT;
                    break;
                }
                if (lcn == 1792 || lcn == 1793) {
                    retVal = MessageType.SY_IDLE;
                    break;
                }
                if (lcn != 2047) break;
                retVal = MessageType.CA_ENDD;
                break;
            }
            case 2: {
                retVal = MessageType.CA_STRT;
                break;
            }
            case 5: {
                retVal = MessageType.CA_PAGE;
                break;
            }
            case 6: {
                retVal = MessageType.ID_RDIO;
                break;
            }
            case 9: {
                retVal = MessageType.DA_STRT;
                break;
            }
            case 11: {
                retVal = MessageType.RA_REGI;
                break;
            }
        }
        return retVal;
    }

    public int getColorCode() {
        return this.getMessage().getInt(DIGITAL_COLOR_CODE);
    }

    public int getSite() {
        return this.getMessage().getInt(SITE);
    }

    public int getMessageTypeNumber() {
        return this.getMessage().getInt(TYPE);
    }

    public boolean hasToIdentifier() {
        return this.getMessageType() != MessageType.SY_IDLE;
    }

    public int getLCN() {
        return this.getMessage().getInt(CHANNEL_NUMBER);
    }

    public long getLCNFrequency() {
        return this.getSiteFrequency(this.getLCN());
    }

    public PassportBand getSiteBand() {
        return PassportBand.lookup(this.getMessage().getInt(SITE_BAND));
    }

    public PassportBand getNeighborBand() {
        return PassportBand.lookup(this.getMessage().getInt(NEIGHBOR_BAND));
    }

    public int getFree() {
        return this.getMessage().getInt(FREE);
    }

    public long getFreeFrequency() {
        return this.getSiteFrequency(this.getFree());
    }

    public long getNeighborFrequency() {
        if (this.getMessageType() == MessageType.SY_IDLE) {
            PassportBand band = this.getNeighborBand();
            return band.getFrequency(this.getFree());
        }
        return 0L;
    }

    public boolean hasFromIdentifier() {
        return this.getMessageType() == MessageType.ID_RDIO;
    }

    private void pad(StringBuilder sb, int length) {
        while (sb.length() < length) {
            sb.append(" ");
        }
    }

    public String format(int number, int decimalPlaces) {
        return StringUtils.leftPad((String)Integer.valueOf(number).toString(), (int)decimalPlaces, (char)'0');
    }

    public String format(String val, int places) {
        return StringUtils.leftPad((String)val, (int)places);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.PASSPORT;
    }

    public long getSiteFrequency(int channel) {
        PassportBand band;
        if (this.mIdleMessage != null && 0 < channel && channel < 1792 && (band = this.mIdleMessage.getSiteBand()) != PassportBand.BAND_UNKNOWN) {
            return band.getFrequency(channel);
        }
        return 0L;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DCC:").append(this.getColorCode());
        switch (this.getMessageType()) {
            case SY_IDLE: {
                sb.append(" IDLE SITE:").append(this.format(this.getSite(), 3));
                sb.append(" NEIGHBOR:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case CA_PAGE: {
                sb.append(" PAGING TG:").append(this.getToIdentifier());
                sb.append(" SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                sb.append(" FREE:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case CA_STRT: {
                sb.append(" CALL TG:").append(this.getToIdentifier());
                sb.append(" SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                sb.append(" FREE:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case DA_STRT: {
                sb.append(" ** DATA TG:").append(this.getToIdentifier());
                sb.append(" SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                sb.append(" FREE:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case CA_ENDD: {
                sb.append(" END  TG:").append(this.getToIdentifier());
                sb.append(" SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                sb.append(" FREE:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case ID_RDIO: {
                sb.append(" MOBILE ID MIN:").append(this.getFromIdentifier());
                sb.append(" FREE:").append(this.format(this.getFree(), 3)).append("/").append(this.getFreeFrequency());
                break;
            }
            case ID_TGAS: {
                sb.append(" ASSIGN TALKGROUP:").append(this.getToIdentifier());
                sb.append(" SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                break;
            }
            case RA_REGI: {
                sb.append(" RADIO REGISTER TG: ").append(this.getToIdentifier());
                break;
            }
            default: {
                sb.append(" UNKNOWN SITE:").append(this.format(this.getSite(), 3));
                sb.append(" CHAN:").append(this.format(this.getLCN(), 4)).append("/").append(this.getLCNFrequency());
                sb.append(" FREE:");
                int free = this.getFree();
                sb.append(this.format(free, 3));
                if (free > 0 && free < 896) {
                    sb.append("/");
                    sb.append(this.getFreeFrequency());
                }
                sb.append(" TYP:").append(this.format(this.getMessageTypeNumber(), 2));
                sb.append(" TG:").append(this.getToIdentifier());
            }
        }
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public boolean matches(PassportMessage otherMessage) {
        return this.getMessage().equals(otherMessage.getMessage());
    }
}

