/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

import io.github.dsheirer.module.decode.p25.reference.Duplex;
import io.github.dsheirer.module.decode.p25.reference.SessionMode;

public class ServiceOptions {
    private static final int EMERGENCY_FLAG = 128;
    private static final int ENCRYPTION_FLAG = 64;
    private static final int DUPLEX = 32;
    private static final int SESSION_MODE = 16;
    protected int mServiceOptions;

    public ServiceOptions(int serviceOptions) {
        this.mServiceOptions = serviceOptions;
    }

    public boolean isEmergency() {
        return this.isSet(128);
    }

    public boolean isEncrypted() {
        return this.isSet(64);
    }

    public Duplex getDuplex() {
        return this.isSet(32) ? Duplex.FULL : Duplex.HALF;
    }

    public SessionMode getSessionMode() {
        return this.isSet(16) ? SessionMode.PACKET : SessionMode.CIRCUIT;
    }

    public boolean isPacket() {
        return this.getSessionMode() == SessionMode.PACKET;
    }

    public boolean isVoice() {
        return this.getSessionMode() == SessionMode.CIRCUIT;
    }

    private boolean isSet(int mask) {
        return (this.mServiceOptions & mask) == mask;
    }
}

