/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

import java.util.ArrayList;
import java.util.List;

public enum Service {
    EXTENDED_SERVICES(0x800000L),
    EXTENDED_SERVICES_EXTENSION(0x400000L),
    NETWORK_ACTIVE(0x200000L),
    RESERVED_4(0x100000L),
    GROUP_VOICE(524288L),
    INDIVIDUAL_VOICE(262144L),
    PSTN_TO_UNIT_VOICE(131072L),
    UNIT_TO_PSTN_VOICE(65536L),
    RESERVED_9(32768L),
    GROUP_DATA(16384L),
    INDIVIDUAL_DATA(8192L),
    RESERVED_12(4096L),
    UNIT_REGISTRATION(2048L),
    GROUP_AFFILIATION(1024L),
    GROUP_AFFILIATION_QUERY(512L),
    AUTHENTICATION(256L),
    ENCRYPTION_SETTINGS(128L),
    USER_STATUS(64L),
    USER_MESSAGE(32L),
    UNIT_STATUS(16L),
    USER_STATUS_QUERY(8L),
    UNIT_STATUS_QUERY(4L),
    UNIT_PAGE(2L),
    EMERGENCY_ALARM(1L),
    UNKNOWN(0L);

    private long mCode;

    private Service(long code) {
        this.mCode = code;
    }

    public long getCode() {
        return this.mCode;
    }

    public static boolean isSupported(Service service, long serviceBitmap) {
        return (service.getCode() & serviceBitmap) == service.getCode();
    }

    public static List<Service> getServices(long serviceBitmap) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : Service.values()) {
            if (!Service.isSupported(service, serviceBitmap) || service == UNKNOWN) continue;
            services.add(service);
        }
        return services;
    }
}

