/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public enum NetworkAddressType {
    IPV4_STATIC_ADDRESS("IPV4 STATIC ADDRESS"),
    IPV4_DYNAMIC_ADDRESS("IPV4 DYNAMIC ADDRESS"),
    RESERVED("RESERVED"),
    NO_ADDRESS("NO ADDRESS"),
    UNKNOWN("UNKNOWN");

    private String mLabel;

    private NetworkAddressType(String label) {
        this.mLabel = label;
    }

    public String toString() {
        return this.mLabel;
    }

    public static NetworkAddressType fromValue(int value) {
        switch (value) {
            case 0: {
                return IPV4_STATIC_ADDRESS;
            }
            case 1: {
                return IPV4_DYNAMIC_ADDRESS;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return RESERVED;
            }
            case 15: {
                return NO_ADDRESS;
            }
        }
        return UNKNOWN;
    }
}

