/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public enum ExtendedFunction {
    RADIO_CHECK(0, "RADIO CHECK"),
    RADIO_DETACH(125, "RADIO DETACH"),
    RADIO_UNINHIBIT(126, "RADIO UNINHIBIT"),
    RADIO_INHIBIT(127, "RADIO INHIBIT"),
    RADIO_CHECK_ACK(128, "RADIO CHECK ACK"),
    RADIO_DETACH_ACK(253, "RADIO DETACH ACK"),
    RADIO_UNINHIBIT_ACK(254, "RADIO UNINHIBIT ACK"),
    RADIO_INHIBIT_ACK(255, "RADIO INHIBIT ACK"),
    GROUP_CONTROL_COMMAND(256, "GROUP CONTROL COMMAND"),
    UNIT_DYNAMIC_COMMAND(512, "UNIT DYNAMIC COMMAND"),
    GROUP_DYNAMIC_COMMAND(768, "GROUP DYNAMIC COMMAND"),
    UNKNOWN(-1, "UNKNOWN");

    private int mFunction;
    private String mLabel;

    private ExtendedFunction(int function, String label) {
        this.mFunction = function;
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.mLabel;
    }

    public static ExtendedFunction fromValue(int function) {
        switch (function) {
            case 0: {
                return RADIO_CHECK;
            }
            case 125: {
                return RADIO_DETACH;
            }
            case 126: {
                return RADIO_UNINHIBIT;
            }
            case 127: {
                return RADIO_INHIBIT;
            }
            case 128: {
                return RADIO_CHECK_ACK;
            }
            case 253: {
                return RADIO_DETACH_ACK;
            }
            case 254: {
                return RADIO_UNINHIBIT_ACK;
            }
            case 255: {
                return RADIO_INHIBIT_ACK;
            }
        }
        if ((function & 0x100) == 256) {
            return GROUP_CONTROL_COMMAND;
        }
        if ((function & 0x200) == 512) {
            return UNIT_DYNAMIC_COMMAND;
        }
        if ((function & 0x300) == 768) {
            return GROUP_DYNAMIC_COMMAND;
        }
        return UNKNOWN;
    }
}

