/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public enum DenyReason {
    RESERVED(0),
    REQUESTING_UNIT_NOT_VALID(16),
    REQUESTING_UNIT_NOT_AUTHORIZED_FOR_SERVICE(17),
    TARGET_UNIT_NOT_VALID(32),
    TARGET_UNIT_NOT_AUTHORIZED_FOR_SERVICE(33),
    TARGET_UNIT_REFUSED_CALL(47),
    TARGET_GROUP_NOT_VALID(48),
    TARGET_GROUP_NOT_AUTHORIZED_FOR_SERVICE(49),
    INVALID_DIALING(64),
    TELEPHONE_NUMBER_NOT_AUTHORIZED(65),
    PSTN_NOT_VALID(66),
    CALL_TIMEOUT(80),
    LANDLINE_TERMINATED_CALL(81),
    SUBSCRIBER_UNIT_TERMINATED_CALL(82),
    CALL_PREEMPTED(95),
    SITE_ACCESS_DENIAL(96),
    USER_OR_SYSTEM_DEFINED(97),
    PTT_COLLIDE(103),
    PTT_BONK(119),
    CALL_OPTIONS_NOT_VALID_FOR_SERVICE(240),
    PROTECTION_SERVICE_OPTION_NOT_VALID(241),
    DUPLEX_SERVICE_OPTION_NOT_VALID(242),
    CIRCUIT_OR_PACKET_MODE_OPTION_NOT_VALID(243),
    SYSTEM_DOES_NOT_SUPPORT_SERVICE(255),
    UNKNOWN(-1);

    private int mCode;

    private DenyReason(int code) {
        this.mCode = code;
    }

    public static DenyReason fromCode(int code) {
        if (code == 16) {
            return REQUESTING_UNIT_NOT_VALID;
        }
        if (code == 17) {
            return REQUESTING_UNIT_NOT_AUTHORIZED_FOR_SERVICE;
        }
        if (code == 32) {
            return TARGET_UNIT_NOT_VALID;
        }
        if (code == 33) {
            return TARGET_UNIT_NOT_AUTHORIZED_FOR_SERVICE;
        }
        if (code == 47) {
            return TARGET_UNIT_REFUSED_CALL;
        }
        if (code == 48) {
            return TARGET_GROUP_NOT_VALID;
        }
        if (code == 49) {
            return TARGET_GROUP_NOT_AUTHORIZED_FOR_SERVICE;
        }
        if (code == 64) {
            return INVALID_DIALING;
        }
        if (code == 65) {
            return TELEPHONE_NUMBER_NOT_AUTHORIZED;
        }
        if (code == 66) {
            return PSTN_NOT_VALID;
        }
        if (code == 80) {
            return CALL_TIMEOUT;
        }
        if (code == 81) {
            return LANDLINE_TERMINATED_CALL;
        }
        if (code == 82) {
            return SUBSCRIBER_UNIT_TERMINATED_CALL;
        }
        if (code == 95) {
            return CALL_PREEMPTED;
        }
        if (code == 96) {
            return SITE_ACCESS_DENIAL;
        }
        if (code == 240) {
            return CALL_OPTIONS_NOT_VALID_FOR_SERVICE;
        }
        if (code == 241) {
            return PROTECTION_SERVICE_OPTION_NOT_VALID;
        }
        if (code == 242) {
            return DUPLEX_SERVICE_OPTION_NOT_VALID;
        }
        if (code == 243) {
            return CIRCUIT_OR_PACKET_MODE_OPTION_NOT_VALID;
        }
        if (code == 103) {
            return PTT_COLLIDE;
        }
        if (code == 119) {
            return PTT_BONK;
        }
        if (code <= 94) {
            return RESERVED;
        }
        if (code >= 97) {
            return USER_OR_SYSTEM_DEFINED;
        }
        return UNKNOWN;
    }
}

