/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.BitSetFullException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearFeedbackShiftRegister {
    private static final Logger mLog = LoggerFactory.getLogger(LinearFeedbackShiftRegister.class);
    private static long MASK = 0xFFFFFFFFFFFL;
    private static long TAP_43 = 0x80000000000L;
    private static long TAP_33 = 0x200000000L;
    private static long TAP_19 = 524288L;
    private static long TAP_14 = 16384L;
    private static long TAP_8 = 256L;
    private static long TAP_3 = 8L;
    private boolean mCurrentOutput;
    private long mRegisters;
    private int mWacn;
    private int mSystem;
    private int mNac;

    public void updateSeed(int wacn, int system, int nac) {
        this.mWacn = wacn;
        this.mSystem = system;
        this.mNac = nac;
        int temp = 1;
        long tempShift = temp << 24;
        this.mRegisters = (long)(0xFFFFF & wacn) << 24;
        this.mRegisters += (long)((0xFFF & system) << 12);
        this.mRegisters += (long)(0xFFF & nac);
        if (this.mRegisters == 0L) {
            this.mRegisters = 0xFFFFFFFFFFFL;
        }
        this.mCurrentOutput = this.getTap(TAP_43);
    }

    public boolean isCurrent(int wacn, int system, int nac) {
        return this.mWacn == wacn && this.mSystem == system && this.mNac == nac;
    }

    public BinaryMessage generateScramblingSequence(int wacn, int system, int nac) {
        this.updateSeed(wacn, system, nac);
        BinaryMessage sequence = new BinaryMessage(4320);
        try {
            for (int x = 0; x < 4320; ++x) {
                sequence.add(this.next());
            }
        }
        catch (BitSetFullException bitSetFullException) {
            // empty catch block
        }
        return sequence;
    }

    public boolean next() {
        boolean retVal;
        boolean feedback = retVal = this.getTap(TAP_43);
        feedback ^= this.getTap(TAP_33);
        feedback ^= this.getTap(TAP_19);
        feedback ^= this.getTap(TAP_14);
        feedback ^= this.getTap(TAP_8);
        this.mRegisters <<= 1;
        this.mRegisters &= MASK;
        if (feedback ^= this.getTap(TAP_3)) {
            ++this.mRegisters;
        }
        return retVal;
    }

    private boolean getTap(long tap) {
        return (this.mRegisters & tap) == tap;
    }
}

