/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Encryption;
import io.github.dsheirer.module.decode.p25.reference.RegroupOptions;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class L3HarrisRegroupCommand
extends MacStructure {
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] LENGTH = new int[]{18, 19, 20, 21, 22, 23};
    private static final int[] REGROUP_OPTIONS = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] SUPERGROUP = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] KEY_ID = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] RADIO_1 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] RADIO_2 = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    private static final int[] RADIO_3 = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135};
    private static final int[] ALGORITHM_ID = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] TALKGROUP_1 = new int[]{72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] TALKGROUP_2 = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] TALKGROUP_3 = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119};
    private static final int[] TALKGROUP_4 = new int[]{120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135};
    private RegroupOptions mRegroupOptions;
    private PatchGroupIdentifier mPatchGroupIdentifier;
    private List<Identifier> mIdentifiers;

    public L3HarrisRegroupCommand(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getVendor() == Vendor.HARRIS) {
            sb.append("L3HARRIS ");
        } else {
            sb.append("WARNING: UNKNOWN VENDOR:").append((Object)this.getVendor());
        }
        if (this.getRegroupOptions().isActivate()) {
            sb.append(" ACTIVATE");
            sb.append(this.getRegroupOptions().isPatch() ? " TWO-WAY PATCH" : " ONE-WAY SIMUL-SELECT");
            sb.append(" SUPERGROUP:").append(((PatchGroup)this.getPatchGroup().getValue()).getPatchGroup().getValue());
            sb.append(" V").append(this.getRegroupOptions().getSupergroupSequenceNumber());
            sb.append(" V").append(this.getRegroupOptions().getSupergroupSequenceNumber());
            if (this.getRegroupOptions().isActivate()) {
                if (this.getRegroupOptions().isTalkgroupAddress()) {
                    sb.append(" INCLUDE TALKGROUPS:");
                    sb.append(((PatchGroup)this.getPatchGroup().getValue()).getPatchedTalkgroupIdentifiers().stream().map(tg -> ((Integer)tg.getValue()).toString()).collect(Collectors.joining(",")));
                    Encryption encryption = this.getEncryptionAlgorithm();
                    if (encryption != Encryption.UNENCRYPTED) {
                        sb.append(" USE ENCRYPTION:").append(encryption.name());
                        sb.append(" KEY:").append(this.getKeyId());
                    }
                } else {
                    sb.append(" INCLUDE RADIOS:");
                    sb.append(((PatchGroup)this.getPatchGroup().getValue()).getPatchedRadioIdentifiers().stream().map(radio -> ((Integer)radio.getValue()).toString()).collect(Collectors.joining(",")));
                }
            }
        } else {
            sb.append(" DEACTIVATE SUPERGROUP:").append(((PatchGroup)this.getPatchGroup().getValue()).getPatchGroup().getValue());
        }
        sb.append(" MSG LENGTH:").append(this.getLength());
        return sb.toString();
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR, this.getOffset()));
    }

    public int getLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    public RegroupOptions getRegroupOptions() {
        if (this.mRegroupOptions == null) {
            this.mRegroupOptions = new RegroupOptions(this.getMessage().getInt(REGROUP_OPTIONS, this.getOffset()));
        }
        return this.mRegroupOptions;
    }

    public int getKeyId() {
        return this.getMessage().getInt(KEY_ID, this.getOffset());
    }

    public Encryption getEncryptionAlgorithm() {
        return Encryption.fromValue(this.getMessage().getInt(ALGORITHM_ID, this.getOffset()));
    }

    public PatchGroupIdentifier getPatchGroup() {
        if (this.mPatchGroupIdentifier == null) {
            TalkgroupIdentifier patchGroupId = APCO25Talkgroup.create(this.getMessage().getInt(SUPERGROUP, this.getOffset()));
            PatchGroup patchGroup = new PatchGroup(patchGroupId, this.getRegroupOptions().getSupergroupSequenceNumber());
            if (this.getRegroupOptions().isTalkgroupAddress()) {
                int talkgroup1 = this.getMessage().getInt(TALKGROUP_1, this.getOffset());
                if (talkgroup1 > 0) {
                    patchGroup.addPatchedTalkgroup(APCO25Talkgroup.create(talkgroup1));
                    int talkgroup2 = this.getMessage().getInt(TALKGROUP_2, this.getOffset());
                    if (talkgroup2 > 0) {
                        patchGroup.addPatchedTalkgroup(APCO25Talkgroup.create(talkgroup2));
                        int talkgroup3 = this.getMessage().getInt(TALKGROUP_3, this.getOffset());
                        if (talkgroup3 > 0) {
                            patchGroup.addPatchedTalkgroup(APCO25Talkgroup.create(talkgroup3));
                            int talkgroup4 = this.getMessage().getInt(TALKGROUP_4, this.getOffset());
                            if (talkgroup4 > 0) {
                                patchGroup.addPatchedTalkgroup(APCO25Talkgroup.create(talkgroup4));
                            }
                        }
                    }
                }
            } else {
                int radio1 = this.getMessage().getInt(RADIO_1, this.getOffset());
                if (radio1 > 0) {
                    patchGroup.addPatchedRadio(APCO25RadioIdentifier.createTo(radio1));
                    int radio2 = this.getMessage().getInt(RADIO_2, this.getOffset());
                    if (radio2 > 0) {
                        patchGroup.addPatchedRadio(APCO25RadioIdentifier.createTo(radio2));
                        int radio3 = this.getMessage().getInt(RADIO_3, this.getOffset());
                        if (radio3 > 0) {
                            patchGroup.addPatchedRadio(APCO25RadioIdentifier.createTo(radio3));
                        }
                    }
                }
            }
            this.mPatchGroupIdentifier = APCO25PatchGroup.create(patchGroup);
        }
        return this.mPatchGroupIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
        }
        return this.mIdentifiers;
    }
}

