/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.identifier.P25Location;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class L3HarrisGpsLocation
extends MacStructure {
    public static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss");
    private static final DecimalFormat GPS_FORMAT;
    private static final DecimalFormat FIXED;
    private static final int[] OPCODE;
    private static final int[] UNKNOWN;
    private static final int[] VENDOR;
    private static final int[] LENGTH;
    private static final int[] LATITUDE_MINUTES_FRACTIONAL;
    private static final int LATITUDE_HEMISPHERE = 48;
    private static final int[] LATITUDE_MINUTES;
    private static final int[] LATITUDE_DEGREES;
    private static final int[] LONGITUDE_MINUTES_FRACTIONAL;
    private static final int LONGITUDE_HEMISPHERE = 80;
    private static final int[] LONGITUDE_MINUTES;
    private static final int[] LONGITUDE_DEGREES;
    private static final int[] GPS_TIME;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final int[] U5;
    private static final int[] U6;
    private static final int[] U7;
    private static final int[] U8;
    private P25Location mLocation;
    private List<Identifier> mIdentifiers;
    private GeoPosition mGeoPosition;

    public L3HarrisGpsLocation(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public long getTimestampMs() {
        return this.getMessage().getInt(GPS_TIME, this.getOffset()) * 1000;
    }

    public P25Location getLocation() {
        if (this.mLocation == null) {
            this.mLocation = P25Location.createFrom(this.getLatitude(), this.getLongitude());
        }
        return this.mLocation;
    }

    public GeoPosition getGeoPosition() {
        if (this.mGeoPosition == null) {
            this.mGeoPosition = new GeoPosition(this.getLatitude(), this.getLongitude());
        }
        return this.mGeoPosition;
    }

    public double getLatitude() {
        return (this.getLatitudeDegrees() + this.getLatitudeMinutes() / 60.0) * (double)(this.getMessage().get(48 + this.getOffset()) ? -1 : 1);
    }

    private double getLatitudeDegrees() {
        return this.getMessage().getInt(LATITUDE_DEGREES, this.getOffset());
    }

    private double getLatitudeMinutes() {
        return (double)this.getMessage().getInt(LATITUDE_MINUTES, this.getOffset()) + (double)this.getMessage().getInt(LATITUDE_MINUTES_FRACTIONAL, this.getOffset()) / 5000.0;
    }

    public double getLongitude() {
        return (this.getLongitudeDegrees() + this.getLongitudeMinutes() / 60.0) * (double)(this.getMessage().get(80 + this.getOffset()) ? -1 : 1);
    }

    private double getLongitudeDegrees() {
        return this.getMessage().getInt(LONGITUDE_DEGREES, this.getOffset());
    }

    private double getLongitudeMinutes() {
        return (double)this.getMessage().getInt(LONGITUDE_MINUTES, this.getOffset()) + (double)this.getMessage().getInt(LONGITUDE_MINUTES_FRACTIONAL, this.getOffset()) / 5000.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getVendor() == Vendor.HARRIS) {
            sb.append("L3H TALKER GPS ");
        } else {
            sb.append("VENDOR:").append((Object)this.getVendor()).append(" TALKER GPS ");
        }
        sb.append(GPS_FORMAT.format(this.getLatitude())).append(" ").append(GPS_FORMAT.format(this.getLongitude()));
        sb.append(" TIME:").append(SDF.format(this.getTimestampMs()));
        return sb.toString();
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR, this.getOffset()));
    }

    public int getLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLocation());
        }
        return this.mIdentifiers;
    }

    public static void main(String[] args) {
        String[] examples;
        for (String example : examples = new String[]{"8080AAA41106CC031E150E8A53C0E69200061C05E00D9000", "8080AAA41106CC031E150E8A53C0E89300061C2A700D9000", "8080AAA41106CC031E150E8A53C0E99300061C78400D9000", "8080AAA41106D6031E150E8A53C0F29300061CDB200D9000", "8080AAA41106D6031E150E8A53C0F39300061C89100D9000", "8C80AAA41106CC031E150E8A53C11D9800061CE68088C000", "8C80AAA41106CC031E150E8A53C11E9800061C10D088C000", "8880AAA41106CC031E150E8A53C0D39100061C6AF0732000", "8080AAA4111F7C231D0852B152BBB99600001C75700D9000", "8080AAA4111F7C231D0852B152BBBA9700001CC3700D9000", "8480AAA4111F86231D0852B152BBE08D00001C8BD0F67000", "8480AAA4111F86231D0852B152BBE18D00001CD9E0F67000", "8480AAA4111F7C231D0852B152BBEA8C00001C6560F67000", "8480AAA4111F7C231D0852B152BBEB8D00001C7700F67000", "8480AAA4111F7C231D0852B152BBEE8D00001CE480F67000", "8480AAA4111F7C231D0852B152BBF88A00001CDDB0F67000", "8480AAA4111F7C231D0852B152BBF98A00001C8F80F67000", "8480AAA4111F7C231D0852B152BBF88D00001C9570F67000", "8880AAA4111748212525C6B84DBD9C0F080517E600732000", "8880AAA4111748212525C6B84DBDA69F0A08172480732000", "8880AAA4111748212525C6B84DBDA89F0A08174B40732000", "8880AAA4111748212525C6B84DBDAAB4010816B9E0732000", "8880AAA4111748212525C6B84DBDABB401081762A0732000", "8880AAA4111748212525C6B84DBDAC9C0008170650732000", "8C80AAA4111734212525DAB84DBE454200071748A088C000", "9080AAA4111734212525DAB84DBE4E42000717B4E0F0F000", "9080AAA4111734212525DAB84DBE4F42000717E6D0F0F000", "8480AAA4111748212525D0B84DBE868E180217A0A0F67000", "8480AAA4111748212525C6B84DBE87641303170E80F67000", "8480AAA411173E212525BCB84DBE89641303172190F67000", "8480AAA41116A821252468B84DC0C3CF3A0915ECF0F67000", "8480AAA41116A82125247CB84DC0C443130916FBA0F67000", "8480AAA41116A821252486B84DC0C7272005133230F67000", "9080AAA41116BC2325178EB24DBE2855050D15E920F0F000", "8C80AAA41116BC2325178EB24DBE2E71060D142C1088C000", "8C80AAA41116BC2325178EB24DBE2F73030D141C1088C000", "8480AAA411173E232517D4B24DBF03C1020D14B910F67000", "9080AAA411260C21251A90804EBF8A9CAD1A166980F0F000", "9080AAA411261621251B1C804EBF8B8C921A16FAA0F0F000", "8480AAA411263421250F6E814EBFD3982F13168E80F67000", "8480AAA411263421250EEC814EBFD4982F1316FC70F67000", "8480AAA411263421250E60814EBFD5982F131645A0F67000", "8880AAA411087A21251F0E804EC07CB39108143C40732000", "8880AAA411087A21251F54804EC07DB39108140EE0732000", "8480AAA4110820212520EE804EC0AA4ED00116E970F67000", "8480AAA411083E21252094804EC0AB26F702164140F67000", "8480AAA411086621252058804EC0AC26F702169920F67000", "8480AAA411088E2125201C804EC0AD26F702167A00F67000", "8480AAA41108B621251FD6804EC0AEEFE50116DDB0F67000", "8C80AAA4110AD21F25134C804EBFCDBD040A1801F088C000", "8C80AAA4110AD21F25134C804EBFCEBD090A1832C088C000", "8080AAA4110AFA1F25136A804EBFE9A70B0A18A4F00D9000", "9080AAA4111BE41E250DD4AE4DC09B5F010314D660F0F000", "9080AAA4111BE41E250DD4AE4DC09D5F0903149440F0F000", "9080AAA4111BE41E250DD4AE4DC09E5F0903146210F0F000", "8080AAA4111BBC1E250DF2AE4DC0A3022F0714FA900D9000", "8080AAA4111BBC1E250DE8AE4DC0A4022F071484F00D9000", "8080AAA4111BD01E250DE8AE4DC0A5022F07146DB00D9000"}) {
            CorrectedBinaryMessage cbm = new CorrectedBinaryMessage(CorrectedBinaryMessage.loadHex(example));
            L3HarrisGpsLocation gps = new L3HarrisGpsLocation(cbm, 8);
            System.out.println(gps);
        }
    }

    static {
        SDF.setTimeZone(TimeZone.getTimeZone("UTC"));
        GPS_FORMAT = new DecimalFormat("0.000000");
        FIXED = new DecimalFormat("000");
        OPCODE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        UNKNOWN = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
        VENDOR = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
        LENGTH = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
        LATITUDE_MINUTES_FRACTIONAL = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46};
        LATITUDE_MINUTES = new int[]{50, 51, 52, 53, 54, 55};
        LATITUDE_DEGREES = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
        LONGITUDE_MINUTES_FRACTIONAL = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78};
        LONGITUDE_MINUTES = new int[]{82, 83, 84, 85, 86, 87};
        LONGITUDE_DEGREES = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
        GPS_TIME = new int[]{96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
        U2 = new int[]{112, 113, 114, 115, 116, 117, 118, 119};
        U3 = new int[]{120, 121, 122, 123, 124, 125, 126, 127};
        U4 = new int[]{128, 129, 130, 131, 132, 133, 134, 135};
        U5 = new int[]{136, 137, 138, 139, 140, 141, 142, 143};
        U6 = new int[]{144, 145, 146, 147, 148, 149, 150, 151};
        U7 = new int[]{152, 153, 154, 155, 156, 157, 158, 159};
        U8 = new int[]{160, 161, 162, 163, 164, 165, 166, 167};
    }
}

