/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.Collections;
import java.util.List;

public class UnknownVendorMessage
extends MacStructure {
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] LENGTH = new int[]{18, 19, 20, 21, 22, 23};

    public UnknownVendorMessage(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MANUFACTURER MESSAGE VENDOR:").append((Object)this.getVendor());
        sb.append(" LENGTH:").append(this.getMessageLength());
        sb.append(" MSG:").append(this.getMessage().getSubMessage(this.getOffset(), this.getMessage().size()).toHexString());
        return sb.toString();
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR, this.getOffset()));
    }

    public int getMessageLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

