/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class RadioUnitMonitorCommand
extends MacStructure {
    private static final int[] TRANSMIT_TIME = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int SILENT_MONITOR = 24;
    private static final int[] TRANSMIT_MULTIPLIER = new int[]{30, 31};
    private static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private Identifier mSourceAddress;
    private Identifier mTargetAddress;

    public RadioUnitMonitorCommand(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getTargetAddress());
        if (this.isSilentMonitor()) {
            sb.append(" SILENT MONITORING");
        }
        sb.append(" TIME:").append(this.getTransmitTime());
        sb.append(" MULTIPLIER:").append(this.getTransmitMultiplier());
        return sb.toString();
    }

    public boolean isSilentMonitor() {
        return this.getMessage().get(24 + this.getOffset());
    }

    public int getTransmitTime() {
        return this.getMessage().getInt(TRANSMIT_TIME, this.getOffset());
    }

    public int getTransmitMultiplier() {
        return this.getMessage().getInt(TRANSMIT_MULTIPLIER, this.getOffset());
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

