/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.QueuedResponseReason;
import java.util.ArrayList;
import java.util.List;

public class QueuedResponse
extends MacStructure {
    private static final int ADDITIONAL_INFORMATION_INDICATOR = 8;
    private static final int[] SERVICE_TYPE = new int[]{10, 11, 12, 13, 14, 15};
    private static final int[] REASON = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] ADDITIONAL_INFO = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private QueuedResponseReason mQueuedResponseReason;
    private String mAdditionalInfo;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public QueuedResponse(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" SERVICE:").append((Object)this.getQueuedResponseServiceType());
        sb.append(" REASON:").append((Object)this.getQueuedResponseReason());
        if (this.hasAdditionalInformation()) {
            sb.append(" INFO:").append(this.getAdditionalInfo());
        }
        return sb.toString();
    }

    private boolean hasAdditionalInformation() {
        return this.getMessage().get(8 + this.getOffset());
    }

    public String getAdditionalInfo() {
        if (this.mAdditionalInfo == null) {
            int arguments = this.getMessage().getInt(ADDITIONAL_INFO, this.getOffset());
            this.mAdditionalInfo = Integer.toHexString(arguments).toUpperCase();
        }
        return this.mAdditionalInfo;
    }

    public MacOpcode getQueuedResponseServiceType() {
        return MacOpcode.fromValue(this.getMessage().getInt(SERVICE_TYPE, this.getOffset()));
    }

    public QueuedResponseReason getQueuedResponseReason() {
        if (this.mQueuedResponseReason == null) {
            this.mQueuedResponseReason = QueuedResponseReason.fromCode(this.getMessage().getInt(REASON, this.getOffset()));
        }
        return this.mQueuedResponseReason;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

