/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.audio.codec.mbe.IEncryptionSyncParameters;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.identifier.encryption.EncryptionKeyIdentifier;
import io.github.dsheirer.module.decode.p25.audio.Phase2EncryptionSyncParameters;
import io.github.dsheirer.module.decode.p25.identifier.encryption.APCO25EncryptionKey;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class PushToTalk
extends MacStructure {
    private static int MESSAGE_INDICATOR_START = 8;
    private static int MESSAGE_INDICATOR_END = 79;
    private static int[] ALGORITHM_ID = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private static int[] KEY_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static int[] SOURCE_ADDRESS = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    private static int[] GROUP_ADDRESS = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143};
    private EncryptionKeyIdentifier mEncryptionKey;
    private Identifier mSourceAddress;
    private Identifier mGroupAddress;
    private List<Identifier> mIdentifiers;

    public PushToTalk(CorrectedBinaryMessage message) {
        super(message, 0);
    }

    @Override
    public MacOpcode getOpcode() {
        return MacOpcode.PUSH_TO_TALK;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        if (this.isEncrypted()) {
            sb.append(" ").append(this.getEncryptionKey());
            sb.append(" MI:").append(this.getMessageIndicator());
        }
        return sb.toString();
    }

    public boolean isEncrypted() {
        return ((EncryptionKey)this.getEncryptionKey().getValue()).isEncrypted();
    }

    public IEncryptionSyncParameters getEncryptionSyncParameters() {
        return new Phase2EncryptionSyncParameters(this.getEncryptionKey(), this.getMessageIndicator());
    }

    public String getMessageIndicator() {
        return this.getMessage().getHex(MESSAGE_INDICATOR_START + this.getOffset(), MESSAGE_INDICATOR_END + this.getOffset());
    }

    public EncryptionKeyIdentifier getEncryptionKey() {
        if (this.mEncryptionKey == null) {
            this.mEncryptionKey = EncryptionKeyIdentifier.create(APCO25EncryptionKey.create(this.getMessage().getInt(ALGORITHM_ID, this.getOffset()), this.getMessage().getInt(KEY_ID, this.getOffset())));
        }
        return this.mEncryptionKey;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS, this.getOffset()));
        }
        return this.mGroupAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceAddress());
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getEncryptionKey());
        }
        return this.mIdentifiers;
    }
}

