/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Nac;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class MacRelease
extends MacStructure {
    private static final int UNFORCED_FORCED_FLAG = 8;
    private static final int CALL_AUDIO_FLAG = 9;
    private static final int[] TARGET_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] COLOR_CODE = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;
    private Identifier mNac;

    public MacRelease(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" NAC:").append(this.getNac());
        if (this.isForcedPreemption()) {
            sb.append(" FORCED");
        } else {
            sb.append(" UNFORCED");
        }
        if (this.isTalkerPreemption()) {
            sb.append(" TALKER");
        } else {
            sb.append(" CALL");
        }
        sb.append(" PREEMPTION");
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getNac() {
        if (this.mNac == null) {
            this.mNac = APCO25Nac.create(this.getMessage().getInt(COLOR_CODE, this.getOffset()));
        }
        return this.mNac;
    }

    public boolean isForcedPreemption() {
        return this.getMessage().get(8 + this.getOffset());
    }

    public boolean isTalkerPreemption() {
        return this.getMessage().get(9 + this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getNac());
        }
        return this.mIdentifiers;
    }
}

