/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25P2ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelGrantUpdateMultipleExplicit
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] SERVICE_OPTIONS_A = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] TRANSMIT_FREQUENCY_BAND_A = new int[]{16, 17, 18, 19};
    private static final int[] TRANSMIT_CHANNEL_NUMBER_A = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RECEIVE_FREQUENCY_BAND_A = new int[]{32, 33, 34, 35};
    private static final int[] RECEIVE_CHANNEL_NUMBER_A = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] GROUP_ADDRESS_A = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_OPTIONS_B = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] TRANSMIT_FREQUENCY_BAND_B = new int[]{72, 73, 74, 75};
    private static final int[] TRANSMIT_CHANNEL_NUMBER_B = new int[]{76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] RECEIVE_FREQUENCY_BAND_B = new int[]{88, 89, 90, 91};
    private static final int[] RECEIVE_CHANNEL_NUMBER_B = new int[]{92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] GROUP_ADDRESS_B = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119};
    private List<Identifier> mIdentifiers;
    private VoiceServiceOptions mVoiceServiceOptionsA;
    private Identifier mGroupAddressA;
    private APCO25Channel mChannelA;
    private VoiceServiceOptions mVoiceServiceOptionsB;
    private Identifier mGroupAddressB;
    private APCO25Channel mChannelB;

    public GroupVoiceChannelGrantUpdateMultipleExplicit(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" GROUP-A:").append(this.getGroupAddressA());
        sb.append(" CHAN-A:").append(this.getChannelA());
        sb.append(" ").append(this.getVoiceServiceOptionsA());
        if (this.hasGroupB()) {
            sb.append(" GROUP-B:").append(this.getGroupAddressB());
            sb.append(" CHAN-B:").append(this.getChannelB());
            sb.append(" ").append(this.getVoiceServiceOptionsB());
        }
        return sb.toString();
    }

    public boolean hasGroupB() {
        int groupB = this.getMessage().getInt(GROUP_ADDRESS_B, this.getOffset());
        return this.getMessage().getInt(GROUP_ADDRESS_A, this.getOffset()) != groupB && groupB != 0;
    }

    public VoiceServiceOptions getVoiceServiceOptionsA() {
        if (this.mVoiceServiceOptionsA == null) {
            this.mVoiceServiceOptionsA = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS_A, this.getOffset()));
        }
        return this.mVoiceServiceOptionsA;
    }

    public VoiceServiceOptions getVoiceServiceOptionsB() {
        if (this.mVoiceServiceOptionsB == null) {
            this.mVoiceServiceOptionsB = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS_B, this.getOffset()));
        }
        return this.mVoiceServiceOptionsB;
    }

    public APCO25Channel getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = new APCO25ExplicitChannel(new P25P2ExplicitChannel(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND_A, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER_A, this.getOffset()), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND_A, this.getOffset()), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER_A, this.getOffset())));
        }
        return this.mChannelA;
    }

    public APCO25Channel getChannelB() {
        if (this.mChannelB == null) {
            this.mChannelB = new APCO25ExplicitChannel(new P25P2ExplicitChannel(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND_B, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER_B, this.getOffset()), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND_B, this.getOffset()), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER_B, this.getOffset())));
        }
        return this.mChannelB;
    }

    public Identifier getGroupAddressA() {
        if (this.mGroupAddressA == null) {
            this.mGroupAddressA = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_A, this.getOffset()));
        }
        return this.mGroupAddressA;
    }

    public Identifier getGroupAddressB() {
        if (this.mGroupAddressB == null) {
            this.mGroupAddressB = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_B, this.getOffset()));
        }
        return this.mGroupAddressB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getChannelA());
            this.mIdentifiers.add(this.getChannelB());
            this.mIdentifiers.add(this.getGroupAddressA());
            this.mIdentifiers.add(this.getGroupAddressB());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        channels.add(this.getChannelB());
        return channels;
    }
}

