/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25P2Channel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelGrantUpdate
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] FREQUENCY_BAND_A = new int[]{8, 9, 10, 11};
    private static final int[] CHANNEL_NUMBER_A = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] GROUP_ADDRESS_A = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] FREQUENCY_BAND_B = new int[]{40, 41, 42, 43};
    private static final int[] CHANNEL_NUMBER_B = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] GROUP_ADDRESS_B = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mGroupAddressA;
    private APCO25Channel mChannelA;
    private Identifier mGroupAddressB;
    private APCO25Channel mChannelB;

    public GroupVoiceChannelGrantUpdate(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" GROUP A:").append(this.getGroupAddressA());
        sb.append(" CHAN-A:").append(this.getChannelA());
        sb.append(" GROUP B:").append(this.getGroupAddressB());
        sb.append(" CHAN-B:").append(this.getChannelB());
        return sb.toString();
    }

    public APCO25Channel getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = new APCO25Channel(new P25P2Channel(this.getMessage().getInt(FREQUENCY_BAND_A, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER_A, this.getOffset())));
        }
        return this.mChannelA;
    }

    public APCO25Channel getChannelB() {
        if (this.mChannelB == null) {
            this.mChannelB = new APCO25Channel(new P25P2Channel(this.getMessage().getInt(FREQUENCY_BAND_B, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER_B, this.getOffset())));
        }
        return this.mChannelB;
    }

    public Identifier getGroupAddressA() {
        if (this.mGroupAddressA == null) {
            this.mGroupAddressA = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_A, this.getOffset()));
        }
        return this.mGroupAddressA;
    }

    public Identifier getGroupAddressB() {
        if (this.mGroupAddressB == null) {
            this.mGroupAddressB = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_B, this.getOffset()));
        }
        return this.mGroupAddressB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getChannelA());
            this.mIdentifiers.add(this.getChannelB());
            this.mIdentifiers.add(this.getGroupAddressA());
            this.mIdentifiers.add(this.getGroupAddressB());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        channels.add(this.getChannelB());
        return channels;
    }
}

