/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelGrantExtended
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] SERVICE_OPTIONS = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] TRANSMIT_FREQUENCY_BAND = new int[]{16, 17, 18, 19};
    private static final int[] TRANSMIT_CHANNEL_NUMBER = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RECEIVE_FREQUENCY_BAND = new int[]{32, 33, 34, 35};
    private static final int[] RECEIVE_CHANNEL_NUMBER = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] GROUP_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SOURCE_ADDRESS = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private List<Identifier> mIdentifiers;
    private APCO25Channel mChannel;
    private Identifier mGroupAddress;
    private Identifier mSourceAddress;
    private VoiceServiceOptions mServiceOptions;

    public GroupVoiceChannelGrantExtended(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" ").append(this.getServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS, this.getOffset()));
        }
        return this.mServiceOptions;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER, this.getOffset()), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER, this.getOffset()));
        }
        return this.mChannel;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS, this.getOffset()));
        }
        return this.mGroupAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getSourceAddress());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

