/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class GroupPagingMessage
extends MacStructure {
    private static final int[] ID_COUNT = new int[]{14, 15};
    private static final int[] GROUP_ADDRESS_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] GROUP_ADDRESS_2 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] GROUP_ADDRESS_3 = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] GROUP_ADDRESS_4 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress1;
    private Identifier mTargetAddress2;
    private Identifier mTargetAddress3;
    private Identifier mTargetAddress4;

    public GroupPagingMessage(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" GROUP1:").append(this.getTargetAddress1());
        int count = this.getCount();
        if (count > 1) {
            sb.append(" GROUP2:").append(this.getTargetAddress2());
            if (count > 2) {
                sb.append(" GROUP3:").append(this.getTargetAddress3());
                if (count > 3) {
                    sb.append(" GROUP4:").append(this.getTargetAddress4());
                }
            }
        }
        return sb.toString();
    }

    public static int getIdCount(BinaryMessage message, int offset) {
        return message.getInt(ID_COUNT, offset);
    }

    public int getCount() {
        return GroupPagingMessage.getIdCount(this.getMessage(), this.getOffset());
    }

    public static int getLength(BinaryMessage message, int offset) {
        int count = GroupPagingMessage.getIdCount(message, offset);
        switch (count) {
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 10;
            }
        }
        return 4;
    }

    public Identifier getTargetAddress1() {
        if (this.mTargetAddress1 == null) {
            this.mTargetAddress1 = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_1, this.getOffset()));
        }
        return this.mTargetAddress1;
    }

    public Identifier getTargetAddress2() {
        if (this.mTargetAddress2 == null && this.getCount() >= 2) {
            this.mTargetAddress2 = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_2, this.getOffset()));
        }
        return this.mTargetAddress2;
    }

    public Identifier getTargetAddress3() {
        if (this.mTargetAddress3 == null && this.getCount() >= 3) {
            this.mTargetAddress3 = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_3, this.getOffset()));
        }
        return this.mTargetAddress3;
    }

    public Identifier getTargetAddress4() {
        if (this.mTargetAddress4 == null && this.getCount() >= 4) {
            this.mTargetAddress4 = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_4, this.getOffset()));
        }
        return this.mTargetAddress4;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            int count = this.getCount();
            this.mIdentifiers.add(this.getTargetAddress1());
            if (count > 1) {
                this.mIdentifiers.add(this.getTargetAddress2());
                if (count > 2) {
                    this.mIdentifiers.add(this.getTargetAddress3());
                    if (count > 3) {
                        this.mIdentifiers.add(this.getTargetAddress4());
                    }
                }
            }
        }
        return this.mIdentifiers;
    }
}

