/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AdjacentStatusBroadcastExtended
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] LRA = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int CONVENTIONAL_CHANNEL_FLAG = 16;
    private static final int SITE_FAILURE_FLAG = 17;
    private static final int VALID_INFORMATION_FLAG = 18;
    private static final int ACTIVE_NETWORK_CONNECTION_TO_RFSS_CONTROLLER_FLAG = 19;
    private static final int[] SYSTEM_ID = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RFSS_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SITE_ID = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] TRANSMIT_FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] TRANSMIT_CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] RECEIVE_FREQUENCY_BAND = new int[]{64, 65, 66, 67};
    private static final int[] RECEIVE_CHANNEL_NUMBER = new int[]{68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] SERVICE_CLASS = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private List<Identifier> mIdentifiers;
    private Identifier mLRA;
    private List<String> mSiteFlags;
    private Identifier mSystem;
    private Identifier mRFSS;
    private Identifier mSite;
    private APCO25Channel mChannel;
    private SystemServiceClass mSystemServiceClass;

    public AdjacentStatusBroadcastExtended(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" RFSS:").append(this.getRFSS());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" LRA:").append(this.getLRA());
        sb.append(" CHANNEL:").append(this.getChannel());
        sb.append(" FLAGS:").append(this.getSiteFlags());
        sb.append(" SERVICES:").append(this.getSystemServiceClass().getServices());
        return sb.toString();
    }

    public Identifier getLRA() {
        if (this.mLRA == null) {
            this.mLRA = APCO25Lra.create(this.getMessage().getInt(LRA, this.getOffset()));
        }
        return this.mLRA;
    }

    public List<String> getSiteFlags() {
        if (this.mSiteFlags == null) {
            this.mSiteFlags = new ArrayList<String>();
            if (this.isConventionalChannel()) {
                this.mSiteFlags.add("CONVENTIONAL CHANNEL");
            }
            if (this.isFailedConditionSite()) {
                this.mSiteFlags.add("FAILURE CONDITION");
            }
            if (this.isValidSiteInformation()) {
                this.mSiteFlags.add("VALID INFORMATION");
            }
            if (this.isActiveNetworkConnectionToRfssControllerSite()) {
                this.mSiteFlags.add("ACTIVE RFSS CONNECTION");
            }
        }
        return this.mSiteFlags;
    }

    public boolean isConventionalChannel() {
        return this.getMessage().get(16 + this.getOffset());
    }

    public boolean isFailedConditionSite() {
        return this.getMessage().get(17 + this.getOffset());
    }

    public boolean isValidSiteInformation() {
        return this.getMessage().get(18 + this.getOffset());
    }

    public boolean isActiveNetworkConnectionToRfssControllerSite() {
        return this.getMessage().get(19 + this.getOffset());
    }

    public Identifier getRFSS() {
        if (this.mRFSS == null) {
            this.mRFSS = APCO25Rfss.create(this.getMessage().getInt(RFSS_ID, this.getOffset()));
        }
        return this.mRFSS;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE_ID, this.getOffset()));
        }
        return this.mSite;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM_ID, this.getOffset()));
        }
        return this.mSystem;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER, this.getOffset()), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER, this.getOffset()));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = SystemServiceClass.create(this.getMessage().getInt(SERVICE_CLASS, this.getOffset()));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLRA());
            this.mIdentifiers.add(this.getSystem());
            this.mIdentifiers.add(this.getRFSS());
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        return Collections.singletonList(this.getChannel());
    }
}

