/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class AcknowledgeResponse
extends MacStructure {
    private static final int ADDITIONAL_INFORMATION_INDICATOR = 8;
    private static final int EXTENDED_ADDRESS = 9;
    private static final int[] SERVICE_TYPE = new int[]{10, 11, 12, 13, 14, 15};
    private static final int[] TARGET_WACN = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final int[] TARGET_SYSTEM = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] TARGET_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SOURCE_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;
    private Identifier mTargetWacn;
    private Identifier mTargetSystem;
    private Identifier mSourceAddress;

    public AcknowledgeResponse(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        if (this.hasAdditionalInformation()) {
            if (this.hasExtendedAddressing()) {
                sb.append(" WACN:").append(this.getTargetWacn());
                sb.append(" SYS:").append(this.getTargetSystem());
            } else {
                sb.append(" FM:").append(this.getSourceAddress());
            }
        }
        sb.append(" ACKNOWLEDGING:").append(this.getServiceType().toString());
        return sb.toString();
    }

    public boolean hasAdditionalInformation() {
        return this.getMessage().get(8 + this.getOffset());
    }

    public boolean hasExtendedAddressing() {
        return this.getMessage().get(9 + this.getOffset());
    }

    public MacOpcode getServiceType() {
        return MacOpcode.fromValue(this.getMessage().getInt(SERVICE_TYPE, this.getOffset()));
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getTargetWacn() {
        if (this.hasAdditionalInformation() && this.hasExtendedAddressing() && this.mTargetWacn == null) {
            this.mTargetWacn = APCO25Wacn.create(this.getMessage().getInt(TARGET_WACN, this.getOffset()));
        }
        return this.mTargetWacn;
    }

    public Identifier getTargetSystem() {
        if (this.hasAdditionalInformation() && this.hasExtendedAddressing() && this.mTargetSystem == null) {
            this.mTargetSystem = APCO25Wacn.create(this.getMessage().getInt(TARGET_SYSTEM, this.getOffset()));
        }
        return this.mTargetSystem;
    }

    public Identifier getSourceAddress() {
        if (this.hasAdditionalInformation() && !this.hasExtendedAddressing() && this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            if (this.hasAdditionalInformation()) {
                if (this.hasExtendedAddressing()) {
                    this.mIdentifiers.add(this.getTargetWacn());
                    this.mIdentifiers.add(this.getTargetSystem());
                } else {
                    this.mIdentifiers.add(this.getSourceAddress());
                }
            }
        }
        return this.mIdentifiers;
    }
}

