/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.Voice4VOffset;
import io.github.dsheirer.module.decode.p25.phase2.message.P25P2Message;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacPduType;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.List;

public class MacMessage
extends P25P2Message {
    private static int[] PDU_TYPE = new int[]{0, 1, 2};
    private static int[] OFFSET_TO_NEXT_VOICE_4V_START = new int[]{3, 4, 5};
    private static int[] RESERVED = new int[]{6, 7};
    private int mChannelNumber;
    private DataUnitID mDataUnitID;
    private CorrectedBinaryMessage mMessage;
    private MacStructure mMacStructure;

    public MacMessage(int timeslot, DataUnitID dataUnitID, CorrectedBinaryMessage message, long timestamp, MacStructure macStructure) {
        super(timestamp);
        this.mChannelNumber = timeslot;
        this.mDataUnitID = dataUnitID;
        this.mMessage = message;
        this.mMacStructure = macStructure;
    }

    public int getBitErrorCount() {
        return this.getMessage().getCorrectedBitCount();
    }

    @Override
    public int getTimeslot() {
        return this.mChannelNumber;
    }

    public DataUnitID getDataUnitID() {
        return this.mDataUnitID;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public MacStructure getMacStructure() {
        return this.mMacStructure;
    }

    public MacPduType getMacPduType() {
        return MacMessage.getMacPduTypeFromMessage(this.getMessage());
    }

    public static MacPduType getMacPduTypeFromMessage(CorrectedBinaryMessage message) {
        return MacPduType.fromValue(message.getInt(PDU_TYPE));
    }

    public Voice4VOffset getOffsetToNextVoice4VStart() {
        return Voice4VOffset.fromValue(this.getMessage().getInt(OFFSET_TO_NEXT_VOICE_4V_START));
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getMacStructure().getIdentifiers();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TS").append(this.getTimeslot());
        sb.append(" ").append((Object)this.getDataUnitID());
        if (this.isValid()) {
            sb.append(" ").append(this.getMacPduType().toString());
            sb.append(" ").append(this.getMacStructure().toString());
        } else {
            sb.append(" INVALID/CRC ERROR");
        }
        return sb.toString();
    }
}

