/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import java.util.function.Function;

public class VoiceMessageFilter
extends Filter<IMessage, DataUnitID> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public VoiceMessageFilter() {
        super("Voice Timeslot Messages");
        this.add(new FilterElement<DataUnitID>(DataUnitID.VOICE_2));
        this.add(new FilterElement<DataUnitID>(DataUnitID.VOICE_4));
    }

    @Override
    public Function<IMessage, DataUnitID> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof AbstractVoiceTimeslot && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, DataUnitID> {
        private KeyExtractor(VoiceMessageFilter voiceMessageFilter) {
        }

        @Override
        public DataUnitID apply(IMessage message) {
            if (message instanceof AbstractVoiceTimeslot) {
                AbstractVoiceTimeslot voice = (AbstractVoiceTimeslot)message;
                return voice.getDataUnitID();
            }
            return null;
        }
    }
}

