/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ISCHSequence;
import io.github.dsheirer.module.decode.p25.phase2.message.InterSlotSignallingChannel;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.ScramblingSequence;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Timeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.TimeslotFactory;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SuperFrameFragment
implements IMessage {
    private static final int CHANNEL_A_ISCH_START = 0;
    private static final int TIMESLOT_A_START = 40;
    private static final int CHANNEL_B_ISCH_START = 360;
    private static final int TIMESLOT_B_START = 400;
    private static final int CHANNEL_C_ISCH_START = 720;
    private static final int TIMESLOT_C_START = 760;
    private static final int CHANNEL_D_ISCH_START = 1080;
    private static final int TIMESLOT_D_START = 1120;
    private static final int TIMESLOT_D_END = 1440;
    private long mTimestamp;
    private CorrectedBinaryMessage mMessage;
    private InterSlotSignallingChannel mChannel0Isch;
    private InterSlotSignallingChannel mChannel1Isch;
    private Timeslot mTimeslotA;
    private Timeslot mTimeslotB;
    private Timeslot mTimeslotC;
    private Timeslot mTimeslotD;
    private ScramblingSequence mScramblingSequence;

    public SuperFrameFragment(CorrectedBinaryMessage message, long timestamp, ScramblingSequence scramblingSequence) {
        this.mMessage = message;
        this.mTimestamp = timestamp;
        this.mScramblingSequence = scramblingSequence;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    @Override
    public int getTimeslot() {
        return 0;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    public InterSlotSignallingChannel getIschChannel0() {
        if (this.mChannel0Isch == null) {
            this.mChannel0Isch = new InterSlotSignallingChannel(this.getMessage().getSubMessage(0, 40), 0);
        }
        return this.mChannel0Isch;
    }

    public InterSlotSignallingChannel getIschChannel1() {
        if (this.mChannel1Isch == null) {
            this.mChannel1Isch = new InterSlotSignallingChannel(this.getMessage().getSubMessage(360, 400), 1);
        }
        return this.mChannel1Isch;
    }

    public Timeslot getTimeslotA() {
        if (this.mTimeslotA == null) {
            this.mTimeslotA = this.getTimeslot(40, 360, 0, 0);
        }
        return this.mTimeslotA;
    }

    public Timeslot getTimeslotB() {
        if (this.mTimeslotB == null) {
            this.mTimeslotB = this.getTimeslot(400, 720, 1, 1);
        }
        return this.mTimeslotB;
    }

    public Timeslot getTimeslotC() {
        if (this.mTimeslotC == null) {
            this.mTimeslotC = this.getTimeslot(760, 1080, 2, this.isFinalFragment() ? 1 : 0);
        }
        return this.mTimeslotC;
    }

    public Timeslot getTimeslotD() {
        if (this.mTimeslotD == null) {
            this.mTimeslotD = this.getTimeslot(1120, 1440, 3, this.isFinalFragment() ? 0 : 1);
        }
        return this.mTimeslotD;
    }

    public List<Timeslot> getTimeslots() {
        ArrayList<Timeslot> timeslots = new ArrayList<Timeslot>();
        timeslots.add(this.getTimeslotA());
        timeslots.add(this.getTimeslotB());
        if (this.isFinalFragment()) {
            timeslots.add(this.getTimeslotD());
            timeslots.add(this.getTimeslotC());
        } else {
            timeslots.add(this.getTimeslotC());
            timeslots.add(this.getTimeslotD());
        }
        return timeslots;
    }

    public List<Timeslot> getChannel0Timeslots() {
        ArrayList<Timeslot> timeslots = new ArrayList<Timeslot>();
        timeslots.add(this.getTimeslotA());
        if (this.isFinalFragment()) {
            timeslots.add(this.getTimeslotD());
        } else {
            timeslots.add(this.getTimeslotC());
        }
        return timeslots;
    }

    public List<Timeslot> getChannel1Timeslots() {
        ArrayList<Timeslot> timeslots = new ArrayList<Timeslot>();
        timeslots.add(this.getTimeslotB());
        if (this.isFinalFragment()) {
            timeslots.add(this.getTimeslotC());
        } else {
            timeslots.add(this.getTimeslotD());
        }
        return timeslots;
    }

    private Timeslot getTimeslot(int start, int end, int index, int timeslot) {
        CorrectedBinaryMessage message = this.getMessage().getSubMessage(start, end);
        BinaryMessage timeslotSequence = this.mScramblingSequence.getTimeslotSequence(this.getTimeslotOffset() + index);
        return TimeslotFactory.getTimeslot(message, timeslotSequence, timeslot, this.getTimestamp());
    }

    private int getTimeslotOffset() {
        ISCHSequence sequence0 = this.getIschChannel0().getIschSequence();
        if (this.getIschChannel0().isValid()) {
            return sequence0.getTimeslotOffset();
        }
        ISCHSequence sequence1 = this.getIschChannel1().getIschSequence();
        if (this.getIschChannel1().isValid()) {
            return sequence1.getTimeslotOffset();
        }
        return 0;
    }

    private boolean isFinalFragment() {
        ISCHSequence sequence0 = this.getIschChannel0().getIschSequence();
        if (this.getIschChannel0().isValid()) {
            return sequence0.isFinalFragment();
        }
        ISCHSequence sequence1 = this.getIschChannel1().getIschSequence();
        if (this.getIschChannel1().isValid()) {
            return sequence1.isFinalFragment();
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.APCO25_PHASE2;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIschChannel0());
        sb.append(" | ").append(this.getIschChannel1());
        sb.append(" | Channel 0:").append(this.getChannel0Timeslots());
        sb.append(" | Channel 1:").append(this.getChannel1Timeslots());
        return sb.toString();
    }
}

