/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ISCHSequence;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.SuperframeSequence;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterSlotSignallingChannel {
    private static final Logger mLog = LoggerFactory.getLogger(InterSlotSignallingChannel.class);
    private static Map<Long, BinaryMessage> sCodewordMap = new TreeMap<Long, BinaryMessage>();
    private static final int[] RESERVED;
    private static final int[] CHANNEL_NUMBER;
    private static final int[] ISCH_SEQUENCE;
    private static final int INBOUND_SACCH_FREE_INDICATOR = 6;
    private static final int[] SUPERFRAME_SEQUENCE;
    private CorrectedBinaryMessage mMessage;
    private boolean mValid;

    public InterSlotSignallingChannel(BinaryMessage message, int expectedTimeslot) {
        this.decode(message);
        this.mValid = this.getMessage().getCorrectedBitCount() < 9 && this.getTimeslot() == expectedTimeslot;
    }

    private void decode(BinaryMessage message) {
        long codeword = message.getLong(0, 39);
        if (sCodewordMap.containsKey(codeword)) {
            this.mMessage = new CorrectedBinaryMessage(sCodewordMap.get(codeword));
        } else {
            int smallestErrorCount = 16;
            long closestCodeword = 0L;
            for (long validCodeword : sCodewordMap.keySet()) {
                long mask = codeword & validCodeword;
                int errorCount = Long.bitCount(mask);
                if (errorCount >= smallestErrorCount) continue;
                smallestErrorCount = errorCount;
                closestCodeword = validCodeword;
            }
            if (closestCodeword != 0L) {
                this.mMessage = new CorrectedBinaryMessage(sCodewordMap.get(closestCodeword));
                this.mMessage.setCorrectedBitCount(smallestErrorCount);
            } else {
                this.mMessage = new CorrectedBinaryMessage(9);
                this.mMessage.setCorrectedBitCount(9);
            }
        }
    }

    public boolean isValid() {
        return this.mValid;
    }

    public int getBitErrorCount() {
        return this.getMessage().getCorrectedBitCount();
    }

    private CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public int getTimeslot() {
        return this.getMessage().getInt(CHANNEL_NUMBER);
    }

    public ISCHSequence getIschSequence() {
        return ISCHSequence.fromValue(this.getMessage().getInt(ISCH_SEQUENCE));
    }

    public boolean isInboundSacchFree() {
        return this.getMessage().get(6);
    }

    public SuperframeSequence getSuperframeSequence() {
        return SuperframeSequence.fromValue(this.getMessage().getInt(SUPERFRAME_SEQUENCE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isValid()) {
            sb.append("ISCHI ").append(this.getTimeslot());
            sb.append(" ").append((Object)this.getIschSequence());
            sb.append(" ").append((Object)this.getSuperframeSequence());
            sb.append(this.isInboundSacchFree() ? " SACCH:FREE" : " SACCH:BUSY");
        } else {
            sb.append("ISCHI      **INVALID**        ");
        }
        return sb.toString();
    }

    private static RealMatrix toMatrix10(int value) {
        double[] values = new double[9];
        for (int x = 0; x < 7; ++x) {
            int mask = (int)FastMath.pow((double)2.0, (int)x);
            if ((value & mask) != mask) continue;
            values[8 - x] = 1.0;
        }
        return MatrixUtils.createRowRealMatrix((double[])values);
    }

    private static long decodeMatrix(RealMatrix matrix) {
        long decoded = 0L;
        double[] values = matrix.getRow(0);
        for (int x = 0; x < 40; ++x) {
            int value = (int)values[39 - x];
            if ((value & 1) != 1) continue;
            decoded += (long)FastMath.pow((double)2.0, (int)x);
        }
        return decoded;
    }

    static {
        double[][] matrix = new double[][]{{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0}};
        RealMatrix generator = MatrixUtils.createRealMatrix((double[][])matrix);
        for (int x = 0; x < 128; ++x) {
            RealMatrix word = InterSlotSignallingChannel.toMatrix10(x);
            RealMatrix codewordMatrix = word.multiply(generator);
            long codeword = InterSlotSignallingChannel.decodeMatrix(codewordMatrix);
            BinaryMessage message = new BinaryMessage(9);
            message.load(0, 9, x);
            sCodewordMap.put(codeword ^= 0x184229D461L, message);
        }
        RESERVED = new int[]{0, 1};
        CHANNEL_NUMBER = new int[]{2, 3};
        ISCH_SEQUENCE = new int[]{4, 5};
        SUPERFRAME_SEQUENCE = new int[]{7, 8};
    }
}

