/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.ReedSolomon_44_16_29_P25;
import io.github.dsheirer.module.decode.p25.phase2.message.EncryptionSynchronizationSequence;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Voice2Timeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Voice4Timeslot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionSynchronizationSequenceProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(EncryptionSynchronizationSequenceProcessor.class);
    private BinaryMessage mESSA;
    private BinaryMessage mESSB1;
    private BinaryMessage mESSB2;
    private BinaryMessage mESSB3;
    private BinaryMessage mESSB4;
    private int mEssBCounter = 1;
    private int mTimeslot;
    private long mTimestamp;

    public EncryptionSynchronizationSequenceProcessor(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public void process(AbstractVoiceTimeslot abstractVoiceTimeslot) {
        if (abstractVoiceTimeslot instanceof Voice2Timeslot) {
            this.setESSA(((Voice2Timeslot)abstractVoiceTimeslot).getEssA());
            this.mTimestamp = abstractVoiceTimeslot.getTimestamp();
        } else if (abstractVoiceTimeslot instanceof Voice4Timeslot) {
            Voice4Timeslot voice4Timeslot = (Voice4Timeslot)abstractVoiceTimeslot;
            switch (this.mEssBCounter) {
                case 1: {
                    this.setESSB1(voice4Timeslot.getEssB());
                    ++this.mEssBCounter;
                    break;
                }
                case 2: {
                    this.setESSB2(voice4Timeslot.getEssB());
                    ++this.mEssBCounter;
                    break;
                }
                case 3: {
                    this.setESSB3(voice4Timeslot.getEssB());
                    ++this.mEssBCounter;
                    break;
                }
                case 4: {
                    this.setESSB4(voice4Timeslot.getEssB());
                    this.mEssBCounter = 1;
                }
            }
        }
    }

    public void reset() {
        this.mESSA = null;
        this.mESSB1 = null;
        this.mESSB2 = null;
        this.mESSB3 = null;
        this.mESSB4 = null;
        this.mEssBCounter = 1;
    }

    public EncryptionSynchronizationSequence getSequence() {
        if (this.mESSA != null && (this.mESSB1 != null || this.mESSB2 != null || this.mESSB3 != null || this.mESSB4 != null)) {
            int[] output;
            ReedSolomon_44_16_29_P25 rs;
            boolean irrecoverableErrors;
            int x;
            int[] input = new int[63];
            int inputPointer = 0;
            for (x = 27; x >= 0; --x) {
                input[inputPointer++] = this.mESSA.getInt(x * 6, x * 6 + 5);
            }
            if (this.mESSB4 != null) {
                for (x = 3; x >= 0; --x) {
                    input[inputPointer++] = this.mESSB4.getInt(x * 6, x * 6 + 5);
                }
            } else {
                inputPointer += 4;
            }
            if (this.mESSB3 != null) {
                for (x = 3; x >= 0; --x) {
                    input[inputPointer++] = this.mESSB3.getInt(x * 6, x * 6 + 5);
                }
            } else {
                inputPointer += 4;
            }
            if (this.mESSB2 != null) {
                for (x = 3; x >= 0; --x) {
                    input[inputPointer++] = this.mESSB2.getInt(x * 6, x * 6 + 5);
                }
            } else {
                inputPointer += 4;
            }
            if (this.mESSB1 != null) {
                for (x = 3; x >= 0; --x) {
                    input[inputPointer++] = this.mESSB1.getInt(x * 6, x * 6 + 5);
                }
            }
            if (!(irrecoverableErrors = (rs = new ReedSolomon_44_16_29_P25()).decode(input, output = new int[63]))) {
                BinaryMessage message = new BinaryMessage(96);
                int pointer = 0;
                for (int x2 = 43; x2 >= 28; --x2) {
                    if (output[x2] != -1) {
                        message.load(pointer, 6, output[x2]);
                    }
                    pointer += 6;
                }
                return new EncryptionSynchronizationSequence(message, this.mTimeslot, this.mTimestamp);
            }
        }
        return null;
    }

    public void setESSB1(BinaryMessage essB1) {
        this.mESSB1 = essB1;
    }

    public void setESSB2(BinaryMessage essB2) {
        this.mESSB2 = essB2;
    }

    public void setESSB3(BinaryMessage essB3) {
        this.mESSB3 = essB3;
    }

    public void setESSB4(BinaryMessage essB4) {
        this.mESSB4 = essB4;
    }

    public void setESSA(BinaryMessage essA) {
        this.mESSA = essA;
    }
}

