/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message;

import io.github.dsheirer.audio.codec.mbe.IEncryptionSyncParameters;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKeyIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.encryption.APCO25EncryptionKey;
import io.github.dsheirer.module.decode.p25.phase2.message.P25P2Message;
import java.util.ArrayList;
import java.util.List;

public class EncryptionSynchronizationSequence
extends P25P2Message
implements IEncryptionSyncParameters {
    private static final int[] ALGORITHM = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] KEY_ID = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MESSAGE_INDICATOR_1 = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] MESSAGE_INDICATOR_2 = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] MESSAGE_INDICATOR_3 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] MESSAGE_INDICATOR_4 = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] MESSAGE_INDICATOR_5 = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] MESSAGE_INDICATOR_6 = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] MESSAGE_INDICATOR_7 = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] MESSAGE_INDICATOR_8 = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] MESSAGE_INDICATOR_9 = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private BinaryMessage mMessage;
    private EncryptionKeyIdentifier mEncryptionKey;
    private int mTimeslot;

    public EncryptionSynchronizationSequence(BinaryMessage message, int timeslot, long timestamp) {
        super(timestamp);
        this.mMessage = message;
        this.mTimeslot = timeslot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TS").append(this.mTimeslot);
        sb.append(" ESS ").append(this.getEncryptionKey().toString());
        if (this.isEncrypted()) {
            sb.append(" MI:").append(this.getMessageIndicator());
        }
        return sb.toString();
    }

    @Override
    public EncryptionKeyIdentifier getEncryptionKey() {
        if (this.mEncryptionKey == null && this.isValid()) {
            this.mEncryptionKey = EncryptionKeyIdentifier.create(APCO25EncryptionKey.create(this.getAlgorithmId(), this.getEncryptionKeyId()));
        }
        return this.mEncryptionKey;
    }

    public int getAlgorithmId() {
        return this.mMessage.getInt(ALGORITHM);
    }

    public boolean isEncrypted() {
        return this.getEncryptionKey() != null && this.getEncryptionKey().isEncrypted();
    }

    public int getEncryptionKeyId() {
        return this.mMessage.getInt(KEY_ID);
    }

    @Override
    public String getMessageIndicator() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_1, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_2, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_3, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_4, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_5, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_6, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_7, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_8, 2).toUpperCase());
        sb.append(this.mMessage.getHex(MESSAGE_INDICATOR_9, 2).toUpperCase());
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getTimeslot() {
        return this.mTimeslot;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        identifiers.add(this.getEncryptionKey());
        return identifiers;
    }
}

