/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.enumeration;

import java.util.EnumSet;

public enum DataUnitID {
    VOICE_4(0, 0, "VOICE-4"),
    SCRAMBLED_SACCH(3, 57, "SACCH-S"),
    VOICE_2(6, 101, "VOICE-2"),
    SCRAMBLED_FACCH(9, 154, "FACCH-S"),
    UNSCRAMBLED_SACCH(12, 198, "SACCH-U"),
    UNSCRAMBLED_FACCH(15, 255, "FACCH-U"),
    UNKNOWN(-1, 0, "UNKNOWN-");

    private int mValue;
    private int mValueWithParity;
    private String mLabel;
    public static EnumSet<DataUnitID> VALID_VALUES;

    private DataUnitID(int value, int valueWithParity, String label) {
        this.mValue = value;
        this.mValueWithParity = valueWithParity;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getValueWithParity() {
        return this.mValueWithParity;
    }

    public boolean isSACCH() {
        return this == SCRAMBLED_SACCH || this == UNSCRAMBLED_SACCH;
    }

    public boolean isFACCH() {
        return this == SCRAMBLED_FACCH || this == UNSCRAMBLED_FACCH;
    }

    public String toString() {
        return this.mLabel;
    }

    public static DataUnitID fromEncodedValue(int value) {
        int masked = 0xF & value >> 4;
        switch (masked) {
            case 0: {
                return VOICE_4;
            }
            case 3: {
                return SCRAMBLED_SACCH;
            }
            case 6: {
                return VOICE_2;
            }
            case 9: {
                return SCRAMBLED_FACCH;
            }
            case 12: {
                return UNSCRAMBLED_SACCH;
            }
            case 15: {
                return UNSCRAMBLED_FACCH;
            }
        }
        DataUnitID closest = UNKNOWN;
        int errorCount = 4;
        for (DataUnitID duid : VALID_VALUES) {
            int mask = value ^ duid.getValueWithParity();
            int maskErrorCount = Integer.bitCount(mask);
            if (maskErrorCount >= errorCount) continue;
            errorCount = maskErrorCount;
            closest = duid;
        }
        return closest;
    }

    static {
        VALID_VALUES = EnumSet.range(VOICE_4, UNSCRAMBLED_FACCH);
    }
}

