/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.bits.MultiSyncPatternMatcher;
import io.github.dsheirer.bits.SoftSyncDetector;
import io.github.dsheirer.bits.SyncDetector;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.FrameSync;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.sample.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2SyncDetector
implements Listener<Dibit> {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2SyncDetector.class);
    private static final int SYNC_MATCH_THRESHOLD = 4;
    public static final double DEFAULT_SAMPLE_RATE = 50000.0;
    public static final double DEFAULT_SYMBOL_RATE = 6000.0;
    public static final double FREQUENCY_PHASE_CORRECTION_90_DEGREES = 1500.0;
    public static final double FREQUENCY_PHASE_CORRECTION_180_DEGREES = 3000.0;
    private MultiSyncPatternMatcher mMatcher;
    private SoftSyncDetector mPrimarySyncDetector;
    private PLLPhaseInversionDetector mInversionDetector90CW;
    private PLLPhaseInversionDetector mInversionDetector90CCW;
    private PLLPhaseInversionDetector mInversionDetector180;

    public P25P2SyncDetector(ISyncDetectListener syncDetectListener, IPhaseLockedLoop phaseLockedLoop) {
        this.mMatcher = new MultiSyncPatternMatcher(syncDetectListener, 1440, 40);
        this.mPrimarySyncDetector = new SoftSyncDetector(FrameSync.P25_PHASE2_NORMAL.getSync(), 4, syncDetectListener);
        this.mMatcher.add(this.mPrimarySyncDetector);
        if (phaseLockedLoop != null) {
            this.mInversionDetector90CW = new PLLPhaseInversionDetector(this, FrameSync.P25_PHASE2_ERROR_90_CW, phaseLockedLoop, 50000.0, 1500.0);
            this.mMatcher.add(this.mInversionDetector90CW);
            this.mInversionDetector90CCW = new PLLPhaseInversionDetector(this, FrameSync.P25_PHASE2_ERROR_90_CCW, phaseLockedLoop, 50000.0, -1500.0);
            this.mMatcher.add(this.mInversionDetector90CCW);
            this.mInversionDetector180 = new PLLPhaseInversionDetector(this, FrameSync.P25_PHASE2_ERROR_180, phaseLockedLoop, 50000.0, 3000.0);
            this.mMatcher.add(this.mInversionDetector180);
        }
    }

    public int getPrimarySyncMatchErrorCount() {
        return Long.bitCount(this.mMatcher.getCurrentValue() ^ FrameSync.P25_PHASE2_NORMAL.getSync());
    }

    @Override
    public void receive(Dibit dibit) {
        this.mMatcher.receive(dibit.getBit1(), dibit.getBit2());
    }

    public void setSampleRate(double sampleRate) {
        this.mInversionDetector180.setSampleRate(sampleRate);
        this.mInversionDetector90CW.setSampleRate(sampleRate);
        this.mInversionDetector90CCW.setSampleRate(sampleRate);
    }

    public class PLLPhaseInversionDetector
    extends SyncDetector {
        private FrameSync mFrameSync;
        private IPhaseLockedLoop mPhaseLockedLoop;
        private double mSampleRate;
        private double mFrequencyCorrection;
        private double mPllCorrection;

        public PLLPhaseInversionDetector(final P25P2SyncDetector this$0, FrameSync frameSync, IPhaseLockedLoop phaseLockedLoop, double sampleRate, double frequencyCorrection) {
            super(frameSync.getSync());
            this.mFrameSync = frameSync;
            this.mPhaseLockedLoop = phaseLockedLoop;
            this.mFrequencyCorrection = frequencyCorrection;
            this.setSampleRate(sampleRate);
            this.setListener(new ISyncDetectListener(){

                @Override
                public void syncDetected(int bitErrors) {
                    PLLPhaseInversionDetector.this.mPhaseLockedLoop.correctInversion(PLLPhaseInversionDetector.this.mPllCorrection);
                }

                @Override
                public void syncLost(int bitsProcessed) {
                }
            });
        }

        public void setSampleRate(double sampleRate) {
            this.mSampleRate = sampleRate;
            this.mPllCorrection = Math.PI * 2 * this.mFrequencyCorrection / this.mSampleRate;
        }
    }
}

