/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.AdjacentStatusBroadcastAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.AdjacentStatusBroadcastExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.FrequencyBandUpdate;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.FrequencyBandUpdateTDMA;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.FrequencyBandUpdateVUHF;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.NetworkStatusBroadcastAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.NetworkStatusBroadcastExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.RfssStatusBroadcastAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.RfssStatusBroadcastExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.SecondaryControlChannelBroadcastAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.SecondaryControlChannelBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.SystemServiceBroadcast;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2NetworkConfigurationMonitor {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2NetworkConfigurationMonitor.class);
    private Map<Integer, IFrequencyBand> mFrequencyBandMap = new HashMap<Integer, IFrequencyBand>();
    private NetworkStatusBroadcastAbbreviated mNetworkStatusBroadcastAbbreviated;
    private NetworkStatusBroadcastExtended mNetworkStatusBroadcastExtended;
    private RfssStatusBroadcastAbbreviated mRFSSStatusBroadcastAbbreviated;
    private RfssStatusBroadcastExtended mRFSSStatusBroadcastExtended;
    private Map<String, IChannelDescriptor> mSecondaryControlChannels = new TreeMap<String, IChannelDescriptor>();
    private SystemServiceBroadcast mSystemServiceBroadcast;
    private Map<Integer, AdjacentStatusBroadcastAbbreviated> mNeighborSitesAbbreviated = new HashMap<Integer, AdjacentStatusBroadcastAbbreviated>();
    private Map<Integer, AdjacentStatusBroadcastExtended> mNeighborSitesExtended = new HashMap<Integer, AdjacentStatusBroadcastExtended>();

    private String format(Identifier identifier, int width) {
        if (identifier.getValue() instanceof Integer) {
            String hex = StringUtils.leftPad((String)Integer.toHexString((Integer)identifier.getValue()), (int)width, (char)'0');
            return hex.toUpperCase() + "[" + String.valueOf(identifier.getValue()) + "]";
        }
        return identifier.toString();
    }

    public void processMacMessage(MacMessage message) {
        MacStructure mac = message.getMacStructure();
        switch (mac.getOpcode()) {
            case PHASE1_115_IDENTIFIER_UPDATE_TDMA: {
                if (!(mac instanceof FrequencyBandUpdateTDMA)) break;
                FrequencyBandUpdateTDMA tdma = (FrequencyBandUpdateTDMA)mac;
                this.mFrequencyBandMap.put(tdma.getIdentifier(), tdma);
                break;
            }
            case PHASE1_116_IDENTIFIER_UPDATE_V_UHF: {
                if (!(mac instanceof FrequencyBandUpdateVUHF)) break;
                FrequencyBandUpdateVUHF vhf = (FrequencyBandUpdateVUHF)mac;
                this.mFrequencyBandMap.put(vhf.getIdentifier(), vhf);
                break;
            }
            case PHASE1_120_SYSTEM_SERVICE_BROADCAST: {
                if (!(mac instanceof SystemServiceBroadcast)) break;
                this.mSystemServiceBroadcast = (SystemServiceBroadcast)mac;
                break;
            }
            case PHASE1_121_SECONDARY_CONTROL_CHANNEL_BROADCAST_ABBREVIATED: {
                if (!(mac instanceof SecondaryControlChannelBroadcastAbbreviated)) break;
                SecondaryControlChannelBroadcastAbbreviated sccba = (SecondaryControlChannelBroadcastAbbreviated)mac;
                for (IChannelDescriptor channel : sccba.getChannels()) {
                    this.mSecondaryControlChannels.put(channel.toString(), channel);
                }
                break;
            }
            case PHASE1_122_RFSS_STATUS_BROADCAST_ABBREVIATED: {
                if (!(mac instanceof RfssStatusBroadcastAbbreviated)) break;
                this.mRFSSStatusBroadcastAbbreviated = (RfssStatusBroadcastAbbreviated)mac;
                break;
            }
            case PHASE1_123_NETWORK_STATUS_BROADCAST_ABBREVIATED: {
                if (!(mac instanceof NetworkStatusBroadcastAbbreviated)) break;
                this.mNetworkStatusBroadcastAbbreviated = (NetworkStatusBroadcastAbbreviated)mac;
                break;
            }
            case PHASE1_124_ADJACENT_STATUS_BROADCAST_ABBREVIATED: {
                if (!(mac instanceof AdjacentStatusBroadcastAbbreviated)) break;
                AdjacentStatusBroadcastAbbreviated asba = (AdjacentStatusBroadcastAbbreviated)mac;
                this.mNeighborSitesAbbreviated.put((int)((Integer)asba.getSite().getValue()), asba);
                break;
            }
            case PHASE1_125_IDENTIFIER_UPDATE: {
                if (!(mac instanceof FrequencyBandUpdate)) break;
                FrequencyBandUpdate band = (FrequencyBandUpdate)mac;
                this.mFrequencyBandMap.put(band.getIdentifier(), band);
                break;
            }
            case PHASE1_233_SECONDARY_CONTROL_CHANNEL_BROADCAST_EXPLICIT: {
                if (!(mac instanceof SecondaryControlChannelBroadcastExplicit)) break;
                SecondaryControlChannelBroadcastExplicit sccbe = (SecondaryControlChannelBroadcastExplicit)mac;
                for (IChannelDescriptor channel : sccbe.getChannels()) {
                    this.mSecondaryControlChannels.put(channel.toString(), channel);
                }
                break;
            }
            case PHASE1_250_RFSS_STATUS_BROADCAST_EXTENDED: {
                if (!(mac instanceof RfssStatusBroadcastExtended)) break;
                this.mRFSSStatusBroadcastExtended = (RfssStatusBroadcastExtended)mac;
                break;
            }
            case PHASE1_251_NETWORK_STATUS_BROADCAST_EXTENDED: {
                if (!(mac instanceof NetworkStatusBroadcastExtended)) break;
                this.mNetworkStatusBroadcastExtended = (NetworkStatusBroadcastExtended)mac;
                break;
            }
            case PHASE1_252_ADJACENT_STATUS_BROADCAST_EXTENDED: {
                if (!(mac instanceof AdjacentStatusBroadcastExtended)) break;
                AdjacentStatusBroadcastExtended asbe = (AdjacentStatusBroadcastExtended)mac;
                this.mNeighborSitesExtended.put((int)((Integer)asbe.getSite().getValue()), asbe);
            }
        }
    }

    public void reset() {
        this.mFrequencyBandMap.clear();
        this.mNetworkStatusBroadcastAbbreviated = null;
        this.mNetworkStatusBroadcastExtended = null;
        this.mRFSSStatusBroadcastAbbreviated = null;
        this.mRFSSStatusBroadcastExtended = null;
        this.mSecondaryControlChannels.clear();
        this.mSystemServiceBroadcast = null;
        this.mNeighborSitesAbbreviated.clear();
        this.mNeighborSitesExtended.clear();
    }

    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary - Decoder:P25 Phase 2");
        sb.append("\n\nNetwork\n");
        if (this.mNetworkStatusBroadcastAbbreviated != null) {
            sb.append("  WACN:").append(this.format(this.mNetworkStatusBroadcastAbbreviated.getWACN(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mNetworkStatusBroadcastAbbreviated.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mNetworkStatusBroadcastAbbreviated.getNAC(), 3));
            sb.append(" LRA:").append(this.format(this.mNetworkStatusBroadcastAbbreviated.getLRA(), 2));
        } else if (this.mNetworkStatusBroadcastExtended != null) {
            sb.append("  WACN:").append(this.format(this.mNetworkStatusBroadcastExtended.getWACN(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mNetworkStatusBroadcastExtended.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mNetworkStatusBroadcastExtended.getNAC(), 3));
            sb.append(" LRA:").append(this.format(this.mNetworkStatusBroadcastExtended.getLRA(), 2));
        } else {
            sb.append("  UNKNOWN");
        }
        sb.append("\n\nCurrent Site\n");
        if (this.mRFSSStatusBroadcastAbbreviated != null) {
            sb.append("  SYSTEM:").append(this.format(this.mRFSSStatusBroadcastAbbreviated.getSystem(), 3));
            sb.append(" RFSS:").append(this.format(this.mRFSSStatusBroadcastAbbreviated.getRFSS(), 2));
            sb.append(" SITE:").append(this.format(this.mRFSSStatusBroadcastAbbreviated.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mRFSSStatusBroadcastAbbreviated.getLRA(), 2));
            sb.append("  PRI CONTROL CHANNEL:").append(this.mRFSSStatusBroadcastAbbreviated.getChannel());
            sb.append(" DOWNLINK:").append(this.mRFSSStatusBroadcastAbbreviated.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mRFSSStatusBroadcastAbbreviated.getChannel().getUplinkFrequency()).append("\n");
        } else if (this.mRFSSStatusBroadcastExtended != null) {
            sb.append("  SYSTEM:").append(this.format(this.mRFSSStatusBroadcastExtended.getSystem(), 3));
            sb.append(" RFSS:").append(this.format(this.mRFSSStatusBroadcastExtended.getRFSS(), 2));
            sb.append(" SITE:").append(this.format(this.mRFSSStatusBroadcastExtended.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mRFSSStatusBroadcastExtended.getLRA(), 2));
            sb.append("  PRI CONTROL CHANNEL:").append(this.mRFSSStatusBroadcastExtended.getChannel());
            sb.append(" DOWNLINK:").append(this.mRFSSStatusBroadcastExtended.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mRFSSStatusBroadcastExtended.getChannel().getUplinkFrequency()).append("\n");
        } else {
            sb.append("  UNKNOWN");
        }
        if (!this.mSecondaryControlChannels.isEmpty()) {
            this.mSecondaryControlChannels.entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(Objects::nonNull).forEach(entry -> {
                sb.append("  SEC CONTROL CHANNEL:").append(entry.getValue());
                sb.append(" DOWNLINK:").append(((IChannelDescriptor)entry.getValue()).getDownlinkFrequency());
                sb.append(" UPLINK:").append(((IChannelDescriptor)entry.getValue()).getUplinkFrequency()).append("\n");
            });
        }
        if (this.mSystemServiceBroadcast != null) {
            sb.append("  AVAILABLE SERVICES:").append(this.mSystemServiceBroadcast.getAvailableServices());
            sb.append("  SUPPORTED SERVICES:").append(this.mSystemServiceBroadcast.getSupportedServices());
        }
        sb.append("\nNeighbor Sites\n");
        TreeSet<Integer> sites = new TreeSet<Integer>();
        sites.addAll(this.mNeighborSitesAbbreviated.keySet());
        sites.addAll(this.mNeighborSitesExtended.keySet());
        if (sites.isEmpty()) {
            sb.append("  UNKNOWN");
        } else {
            sites.stream().sorted().forEach(site -> {
                if (this.mNeighborSitesAbbreviated.containsKey(site)) {
                    AdjacentStatusBroadcastAbbreviated asb = this.mNeighborSitesAbbreviated.get(site);
                    sb.append("  SYSTEM:").append(this.format(asb.getSystem(), 3));
                    sb.append(" RFSS:").append(this.format(asb.getRFSS(), 2));
                    sb.append(" SITE:").append(this.format(asb.getSite(), 2));
                    sb.append(" LRA:").append(this.format(asb.getLRA(), 2));
                    sb.append(" CHANNEL:").append(asb.getChannel());
                    sb.append(" DOWNLINK:").append(asb.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(asb.getChannel().getUplinkFrequency());
                    sb.append(" STATUS:").append(asb.getSiteFlags()).append("\n");
                } else if (this.mNeighborSitesExtended.containsKey(site)) {
                    AdjacentStatusBroadcastExtended asb = this.mNeighborSitesExtended.get(site);
                    sb.append("  SYSTEM:").append(this.format(asb.getSystem(), 3));
                    sb.append(" RFSS:").append(this.format(asb.getRFSS(), 2));
                    sb.append(" SITE:").append(this.format(asb.getSite(), 2));
                    sb.append(" LRA:").append(this.format(asb.getLRA(), 2));
                    sb.append(" CHANNEL:").append(asb.getChannel());
                    sb.append(" DOWNLINK:").append(asb.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(asb.getChannel().getUplinkFrequency());
                    sb.append(" STATUS:").append(asb.getSiteFlags()).append("\n");
                } else {
                    sb.append(" SITE:").append(site).append(" NOT FOUND IN NEIGHBOR SITE MAPS\n");
                }
            });
        }
        sb.append("\nFrequency Bands\n");
        if (this.mFrequencyBandMap.isEmpty()) {
            sb.append("  UNKNOWN");
        } else {
            this.mFrequencyBandMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append("  ").append(this.formatFrequencyBand((IFrequencyBand)entry.getValue())).append("\n"));
        }
        return sb.toString();
    }

    private String formatFrequencyBand(IFrequencyBand band) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAND:").append(band.getIdentifier());
        sb.append(" ").append(band.isTDMA() ? "TDMA" : "FDMA");
        sb.append(" BASE:").append(band.getBaseFrequency());
        sb.append(" BANDWIDTH:").append(band.getBandwidth());
        sb.append(" SPACING:").append(band.getChannelSpacing());
        sb.append(" TRANSMIT OFFSET:").append(band.getTransmitOffset());
        if (band.isTDMA()) {
            sb.append(" TIMESLOTS:").append(band.getTimeslotCount());
        }
        return sb.toString();
    }
}

