/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.log.ApplicationLog;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageProviderModule;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.audio.P25P2AudioModule;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.P25P2DecoderState;
import io.github.dsheirer.module.decode.p25.phase2.P25P2MessageProcessor;
import io.github.dsheirer.module.decode.p25.phase2.P25P2SuperFrameDetector;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.AudioRecordingManager;
import io.github.dsheirer.record.binary.BinaryReader;
import io.github.dsheirer.sample.Listener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2MessageFramer
implements Listener<Dibit> {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2MessageFramer.class);
    private P25P2SuperFrameDetector mSuperFrameDetector;
    private boolean mAssemblingMessage = false;
    private CorrectedBinaryMessage mBinaryMessage;
    private DataUnitID mDataUnitID;
    private PDUSequence mPDUSequence;
    private int[] mCorrectedNID;
    private int mNAC;
    private int mStatusSymbolDibitCounter = 0;
    private int mTrailingDibitsToSuppress = 0;
    private double mBitRate;
    private long mCurrentTime = System.currentTimeMillis();

    public P25P2MessageFramer(IPhaseLockedLoop phaseLockedLoop, int bitRate) {
        this.mSuperFrameDetector = new P25P2SuperFrameDetector(phaseLockedLoop);
        this.mBitRate = bitRate;
    }

    public P25P2MessageFramer(int bitRate) {
        this(null, bitRate);
    }

    public void setScrambleParameters(ScrambleParameters scrambleParameters) {
        if (this.mSuperFrameDetector != null) {
            this.mSuperFrameDetector.setScrambleParameters(scrambleParameters);
        }
    }

    public void setSampleRate(double sampleRate) {
        this.mSuperFrameDetector.setSampleRate(sampleRate);
    }

    public void setSyncDetectListener(ISyncDetectListener listener) {
        this.mSuperFrameDetector.setSyncDetectListener(listener);
    }

    private long getTimestamp() {
        return this.mCurrentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.mCurrentTime = currentTime;
    }

    private void updateBitsProcessed(int bitsProcessed) {
        if (bitsProcessed > 0) {
            this.mCurrentTime += (long)((double)bitsProcessed / this.mBitRate * 1000.0);
        }
    }

    public void setListener(Listener<IMessage> messageListener) {
        this.mSuperFrameDetector.setListener(messageListener);
    }

    public P25P2SuperFrameDetector getSuperFrameDetector() {
        return this.mSuperFrameDetector;
    }

    @Override
    public void receive(Dibit dibit) {
        this.mSuperFrameDetector.receive(dibit);
    }

    private void reset(int bitsProcessed) {
        this.updateBitsProcessed(bitsProcessed);
        this.mPDUSequence = null;
        this.mBinaryMessage = null;
        this.mAssemblingMessage = false;
        this.mDataUnitID = null;
        this.mNAC = 0;
        this.mSuperFrameDetector.reset();
        this.mStatusSymbolDibitCounter = 0;
    }

    @Override
    public void receive(ByteBuffer buffer) {
        for (byte value : buffer.array()) {
            for (int x = 0; x <= 3; ++x) {
                this.receive(Dibit.parse(value, x));
            }
        }
    }

    public static void main(String[] args) {
        UserPreferences userPreferences = new UserPreferences();
        userPreferences.getJmbeLibraryPreference().setPathJmbeLibrary(Path.of("/home/denny/JMBE/jmbe-1.0.3.jar", new String[0]));
        ApplicationLog applicationLog = new ApplicationLog(userPreferences);
        applicationLog.start();
        Path directory = Paths.get("/home/denny/temp/Harris P25-2 Logs/bits", new String[0]);
        final ScrambleParameters scrambleParameters = new ScrambleParameters(123654, 813, 10);
        Channel channel = new Channel("Phase 2 Test", Channel.ChannelType.TRAFFIC);
        channel.setDecodeConfiguration(new DecodeConfigP25Phase2());
        AliasList aliasList = new AliasList("Test Alias List");
        AudioRecordingManager recordingManager = new AudioRecordingManager(userPreferences);
        recordingManager.start();
        final ProcessingChain processingChain = new ProcessingChain(channel, new AliasModel());
        processingChain.addAudioSegmentListener(recordingManager);
        processingChain.addModule(new P25P2DecoderState(channel, 0));
        processingChain.addModule(new P25P2DecoderState(channel, 1));
        processingChain.addModule(new P25P2AudioModule(userPreferences, 0, aliasList));
        processingChain.addModule(new P25P2AudioModule(userPreferences, 1, aliasList));
        final MessageProviderModule messageProviderModule = new MessageProviderModule();
        processingChain.addModule(messageProviderModule);
        try (final OutputStream logOutput = Files.newOutputStream(directory.resolve("log.txt"), new OpenOption[0]);){
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(directory, "*214601*Hills*TRAFFIC.bits");
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        mLog.debug("\n\nProcessing:" + path.toString() + "\n\n");
                        try {
                            logOutput.write(("Processing:" + path.toString() + "\n").getBytes());
                        }
                        catch (IOException ioe) {
                            mLog.error("Error", (Throwable)ioe);
                        }
                        processingChain.start();
                        P25P2MessageFramer messageFramer = new P25P2MessageFramer(null, DecoderType.P25_PHASE2.getProtocol().getBitRate());
                        messageFramer.setScrambleParameters(scrambleParameters);
                        P25P2MessageProcessor messageProcessor = new P25P2MessageProcessor();
                        messageFramer.setListener(messageProcessor);
                        messageProcessor.setMessageListener(new Listener<IMessage>(){

                            @Override
                            public void receive(IMessage message) {
                                messageProviderModule.receive(message);
                                try {
                                    logOutput.write(message.toString().getBytes());
                                    logOutput.write("\n".getBytes());
                                }
                                catch (IOException ioe) {
                                    mLog.error("Error", (Throwable)ioe);
                                }
                                mLog.debug(message.toString());
                            }
                        });
                        try (BinaryReader reader = new BinaryReader(path, 200);){
                            while (reader.hasNext()) {
                                ByteBuffer buffer = reader.next();
                                messageFramer.receive(buffer);
                            }
                        }
                        catch (Exception ioe) {
                            ioe.printStackTrace();
                        }
                        mLog.debug("**STOPPING PROCESSING CHAIN**");
                        processingChain.stop();
                        mLog.debug("\n============================================================================================================================\n");
                    }
                });
            }
            catch (IOException ioe) {
                mLog.error("Error", (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            mLog.error("Error", (Throwable)ioe);
        }
        recordingManager.stop();
    }
}

