/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.gain.complex.ComplexGainFactory;
import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.dsp.psk.DQPSKGardnerDemodulator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.FrequencyCorrectionSyncMonitor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.P25P2Decoder;
import io.github.dsheirer.module.decode.p25.phase2.P25P2MessageFramer;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.SourceEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2DecoderHDQPSK
extends P25P2Decoder
implements IdentifierUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2DecoderHDQPSK.class);
    protected static final float SYMBOL_TIMING_GAIN = 0.1f;
    protected InterpolatingSampleBuffer mInterpolatingSampleBuffer;
    protected DQPSKGardnerDemodulator mQPSKDemodulator;
    protected CostasLoop mCostasLoop;
    protected P25P2MessageFramer mMessageFramer;
    protected IComplexGainControl mAGC = ComplexGainFactory.getComplexGainControl();
    private Map<Double, float[]> mBasebandFilters = new HashMap<Double, float[]>();
    protected IRealFilter mIBasebandFilter;
    protected IRealFilter mQBasebandFilter;
    private DecodeConfigP25Phase2 mDecodeConfigP25Phase2;
    private FrequencyCorrectionSyncMonitor mFrequencyCorrectionSyncMonitor;

    public P25P2DecoderHDQPSK(DecodeConfigP25Phase2 decodeConfigP25Phase2) {
        super(6000.0);
        this.setSampleRate(25000.0);
        this.mDecodeConfigP25Phase2 = decodeConfigP25Phase2;
    }

    @Override
    public void start() {
        super.start();
        this.mQPSKDemodulator.start();
        if (this.mDecodeConfigP25Phase2 != null && this.mDecodeConfigP25Phase2.getScrambleParameters() != null && !this.mDecodeConfigP25Phase2.isAutoDetectScrambleParameters()) {
            this.mMessageFramer.setScrambleParameters(this.mDecodeConfigP25Phase2.getScrambleParameters());
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.mQPSKDemodulator.stop();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        this.mIBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mQBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mCostasLoop = new CostasLoop(this.getSampleRate(), this.getSymbolRate());
        this.mCostasLoop.setPLLBandwidth(PLLBandwidth.BW_300);
        this.mInterpolatingSampleBuffer = new InterpolatingSampleBuffer(this.getSamplesPerSymbol(), 0.1f);
        this.mQPSKDemodulator = new DQPSKGardnerDemodulator(this.mCostasLoop, this.mInterpolatingSampleBuffer);
        if (this.mMessageFramer != null) {
            this.getDibitBroadcaster().removeListener(this.mMessageFramer);
        }
        this.mMessageFramer = new P25P2MessageFramer(this.mCostasLoop, DecoderType.P25_PHASE2.getProtocol().getBitRate());
        if (this.mDecodeConfigP25Phase2 != null) {
            this.mMessageFramer.setScrambleParameters(this.mDecodeConfigP25Phase2.getScrambleParameters());
        }
        this.mFrequencyCorrectionSyncMonitor = new FrequencyCorrectionSyncMonitor(this.mCostasLoop, this);
        this.mMessageFramer.setSyncDetectListener(this.mFrequencyCorrectionSyncMonitor);
        this.mMessageFramer.setListener(this.getMessageProcessor());
        this.mMessageFramer.setSampleRate(sampleRate);
        this.mQPSKDemodulator.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(System.currentTimeMillis());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    private float[] getBasebandFilter() {
        float[] filter = this.mBasebandFilters.get(this.getSampleRate());
        if (filter == null) {
            FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(50000.0).passBandCutoff(6500.0).passBandAmplitude(1.0).passBandRipple(0.005).stopBandAmplitude(0.0).stopBandStart(7200.0).stopBandRipple(0.01).build();
            try {
                filter = FilterFactory.getTaps(specification);
            }
            catch (FilterDesignException fde) {
                mLog.error("Couldn't design low pass baseband filter for sample rate: " + this.getSampleRate());
            }
            if (filter != null) {
                this.mBasebandFilters.put(this.getSampleRate(), filter);
            } else {
                throw new IllegalStateException("Couldn't design a C4FM baseband filter for sample rate: " + this.getSampleRate());
            }
        }
        return filter;
    }

    @Override
    protected void process(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.mCostasLoop.reset();
                this.setSampleRate(sourceEvent.getValue().doubleValue());
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.mCostasLoop.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.mCostasLoop.reset();
    }

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return new Listener<IdentifierUpdateNotification>(){

            @Override
            public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
                if (identifierUpdateNotification.getIdentifier().getForm() == Form.SCRAMBLE_PARAMETERS && P25P2DecoderHDQPSK.this.mMessageFramer != null) {
                    ScrambleParameters scrambleParameters = (ScrambleParameters)identifierUpdateNotification.getIdentifier().getValue();
                    P25P2DecoderHDQPSK.this.mMessageFramer.setScrambleParameters(scrambleParameters);
                }
            }
        };
    }
}

