/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.dsp.squelch.PowerMonitor;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.DibitToByteBufferAssembler;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.FeedbackDecoder;
import io.github.dsheirer.module.decode.p25.phase2.P25P2MessageProcessor;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import java.nio.ByteBuffer;

public abstract class P25P2Decoder
extends FeedbackDecoder
implements ISourceEventListener,
ISourceEventProvider,
IComplexSamplesListener,
Listener<ComplexSamples>,
IByteBufferProvider {
    private double mSampleRate;
    private Broadcaster<Dibit> mDibitBroadcaster = new Broadcaster();
    private DibitToByteBufferAssembler mByteBufferAssembler = new DibitToByteBufferAssembler(300);
    private P25P2MessageProcessor mMessageProcessor;
    private double mSymbolRate;
    protected PowerMonitor mPowerMonitor = new PowerMonitor();

    public P25P2Decoder(double symbolRate) {
        this.mSymbolRate = symbolRate;
        this.mMessageProcessor = new P25P2MessageProcessor();
        this.mMessageProcessor.setMessageListener(this.getMessageListener());
        this.getDibitBroadcaster().addListener(this.mByteBufferAssembler);
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        super.setSourceEventListener(listener);
        this.mPowerMonitor.setSourceEventListener(listener);
    }

    @Override
    public void removeSourceEventListener() {
        super.removeSourceEventListener();
        this.mPowerMonitor.setSourceEventListener(null);
    }

    protected Broadcaster<Dibit> getDibitBroadcaster() {
        return this.mDibitBroadcaster;
    }

    @Override
    public void setBufferListener(Listener<ByteBuffer> listener) {
        this.mByteBufferAssembler.setBufferListener(listener);
    }

    @Override
    public void removeBufferListener(Listener<ByteBuffer> listener) {
        this.mByteBufferAssembler.removeBufferListener(listener);
    }

    @Override
    public boolean hasBufferListeners() {
        return this.mByteBufferAssembler.hasBufferListeners();
    }

    protected double getSymbolRate() {
        return this.mSymbolRate;
    }

    protected double getSampleRate() {
        return this.mSampleRate;
    }

    public void setSampleRate(double sampleRate) {
        if (sampleRate <= this.getSymbolRate() * 2.0) {
            throw new IllegalArgumentException("Sample rate [" + sampleRate + "] must be > 12000 (2 * " + this.getSymbolRate() + " symbol rate)");
        }
        this.mPowerMonitor.setSampleRate((int)sampleRate);
        this.mSampleRate = sampleRate;
    }

    public float getSamplesPerSymbol() {
        return (float)(this.getSampleRate() / this.getSymbolRate());
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return new Listener<SourceEvent>(){

            @Override
            public void receive(SourceEvent sourceEvent) {
                P25P2Decoder.this.process(sourceEvent);
            }
        };
    }

    protected abstract void process(SourceEvent var1);

    @Override
    public Listener<ComplexSamples> getComplexSamplesListener() {
        return this;
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.P25_PHASE2;
    }

    protected P25P2MessageProcessor getMessageProcessor() {
        return this.mMessageProcessor;
    }
}

