/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.Response;
import java.util.ArrayList;
import java.util.List;

public class UnitRegistrationResponse
extends OSPMessage {
    private static final int[] RESERVED = new int[]{16, 17};
    private static final int[] RESPONSE = new int[]{18, 19};
    private static final int[] SYSTEM_ID = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TARGET_UNIQUE_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Response mResponse;
    private Identifier mSystem;
    private Identifier mTargetUniqueId;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public UnitRegistrationResponse(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TO ADDR:").append(this.getTargetAddress());
        sb.append(" TO ID:").append(this.getTargetUniqueId());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" RESPONSE:").append((Object)this.getResponse());
        return sb.toString();
    }

    public Response getResponse() {
        if (this.mResponse == null) {
            this.mResponse = Response.fromValue(this.getMessage().getInt(RESPONSE));
        }
        return this.mResponse;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM_ID));
        }
        return this.mSystem;
    }

    public Identifier getTargetUniqueId() {
        if (this.mTargetUniqueId == null) {
            this.mTargetUniqueId = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_UNIQUE_ID));
        }
        return this.mTargetUniqueId;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetUniqueId());
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSystem());
        }
        return this.mIdentifiers;
    }
}

