/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class SecondaryControlChannelBroadcastExplicit
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] RFSS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] SITE = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TRANSMIT_FREQUENCY_BAND = new int[]{32, 33, 34, 35};
    private static final int[] TRANSMIT_CHANNEL_NUMBER = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] RESERVED = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] RECEIVE_FREQUENCY_BAND = new int[]{56, 57, 58, 59};
    private static final int[] RECEIVE_CHANNEL_NUMBER = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SYSTEM_SERVICE_CLASS = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mRfss;
    private Identifier mSite;
    private IChannelDescriptor mChannel;
    private SystemServiceClass mSystemServiceClass;
    private List<Identifier> mIdentifiers;

    public SecondaryControlChannelBroadcastExplicit(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClass());
        return sb.toString();
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRfss;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getRfss());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

