/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class SecondaryControlChannelBroadcast
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] RFSS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] SITE = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] FREQUENCY_BAND_A = new int[]{32, 33, 34, 35};
    private static final int[] CHANNEL_NUMBER_A = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SYSTEM_SERVICE_CLASS_A = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FREQUENCY_BAND_B = new int[]{56, 57, 58, 59};
    private static final int[] CHANNEL_NUMBER_B = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SYSTEM_SERVICE_CLASS_B = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mRfss;
    private Identifier mSite;
    private IChannelDescriptor mChannelA;
    private IChannelDescriptor mChannelB;
    private SystemServiceClass mSystemServiceClassA;
    private SystemServiceClass mSystemServiceClassB;
    private List<Identifier> mIdentifiers;

    public SecondaryControlChannelBroadcast(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" CHAN A:").append(this.getChannelA());
        sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClassA());
        if (this.hasChannelB()) {
            sb.append(" CHAN B:").append(this.getChannelB());
            sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClassB());
        }
        return sb.toString();
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRfss;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_A), this.getMessage().getInt(CHANNEL_NUMBER_A));
        }
        return this.mChannelA;
    }

    public SystemServiceClass getSystemServiceClassA() {
        if (this.mSystemServiceClassA == null) {
            this.mSystemServiceClassA = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS_A));
        }
        return this.mSystemServiceClassA;
    }

    private boolean hasChannelB() {
        return this.getMessage().getInt(CHANNEL_NUMBER_A) != this.getMessage().getInt(CHANNEL_NUMBER_B) && this.getMessage().getInt(SYSTEM_SERVICE_CLASS_B) != 0;
    }

    public IChannelDescriptor getChannelB() {
        if (this.hasChannelB() && this.mChannelB == null) {
            this.mChannelB = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_B), this.getMessage().getInt(CHANNEL_NUMBER_B));
        }
        return this.mChannelB;
    }

    public SystemServiceClass getSystemServiceClassB() {
        if (this.mSystemServiceClassB == null) {
            this.mSystemServiceClassB = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS_B));
        }
        return this.mSystemServiceClassB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getRfss());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        if (this.hasChannelB()) {
            channels.add(this.getChannelB());
        }
        return channels;
    }
}

