/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.DataServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class SNDCPDataChannelGrant
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] DATA_SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] DOWNLINK_FREQUENCY_BAND = new int[]{24, 25, 26, 27};
    private static final int[] DOWNLINK_CHANNEL_NUMBER = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] UPLINK_FREQUENCY_BAND = new int[]{40, 41, 42, 43};
    private static final int[] UPLINK_CHANNEL_NUMBER = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DataServiceOptions mServiceOptions;
    private APCO25Channel mChannel;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;

    public SNDCPDataChannelGrant(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" SERVICE OPTIONS:").append(this.getServiceOptions());
        return sb.toString();
    }

    public DataServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new DataServiceOptions(this.getMessage().getInt(DATA_SERVICE_OPTIONS));
        }
        return this.mServiceOptions;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = this.isExplicitChannel() ? APCO25ExplicitChannel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL_NUMBER), this.getMessage().getInt(UPLINK_FREQUENCY_BAND), this.getMessage().getInt(UPLINK_CHANNEL_NUMBER)) : APCO25Channel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    private boolean isExplicitChannel() {
        return this.getMessage().getInt(UPLINK_CHANNEL_NUMBER) != 4095;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            this.mChannels.add(this.getChannel());
        }
        return this.mChannels;
    }
}

