/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.DataServiceOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SNDCPDataChannelAnnouncementExplicit
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] DATA_SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int AUTONOMOUS_ACCESS_FLAG = 24;
    private static final int REQUESTED_ACCESS_FLAG = 25;
    private static final int[] DOWNLINK_FREQUENCY_BAND = new int[]{32, 33, 34, 35};
    private static final int[] DOWNLINK_CHANNEL_NUMBER = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] UPLINK_FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] UPLINK_CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] DATA_ACCESS_CONTROL = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DataServiceOptions mServiceOptions;
    private IChannelDescriptor mChannel;
    private List<IChannelDescriptor> mChannels;

    public SNDCPDataChannelAnnouncementExplicit(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" CHAN:").append(this.getChannel());
        if (this.isAutonomousAccess() && this.isRequestedAccess()) {
            sb.append(" AUTONOMOUS/REQUESTED-ACCESS");
        } else if (this.isAutonomousAccess()) {
            sb.append(" AUTONOMOUS-ACCESS");
        } else if (this.isRequestedAccess()) {
            sb.append(" REQUESTED-ACCESS");
        }
        sb.append(" DAC:").append(this.getDataAccessControl());
        sb.append(" **:").append(this.getMessage().getInt(DATA_SERVICE_OPTIONS));
        sb.append(" SERVICE OPTIONS:").append(this.getServiceOptions());
        return sb.toString();
    }

    public boolean isAutonomousAccess() {
        return this.getMessage().get(24);
    }

    public boolean isRequestedAccess() {
        return this.getMessage().get(25);
    }

    public DataServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new DataServiceOptions(this.getMessage().getInt(DATA_SERVICE_OPTIONS));
        }
        return this.mServiceOptions;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL_NUMBER), this.getMessage().getInt(UPLINK_FREQUENCY_BAND), this.getMessage().getInt(UPLINK_CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    private boolean isExplicitChannel() {
        return this.getMessage().getInt(UPLINK_CHANNEL_NUMBER) != 4095;
    }

    public int getDataAccessControl() {
        return this.getMessage().getInt(DATA_ACCESS_CONTROL);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            this.mChannels.add(this.getChannel());
        }
        return this.mChannels;
    }
}

