/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.Response;
import java.util.ArrayList;
import java.util.List;

public class LocationRegistrationResponse
extends OSPMessage {
    private static final int[] RESERVED = new int[]{16, 17, 18, 19, 20, 21};
    private static final int[] RESPONSE = new int[]{22, 23};
    private static final int[] GROUP_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] RFSS = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SITE = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Response mResponse;
    private Identifier mRfss;
    private Identifier mSite;
    private Identifier mGroupAddress;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public LocationRegistrationResponse(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" GROUP:").append(this.getGroupAddress());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" RESPONSE:").append((Object)this.getResponse());
        return sb.toString();
    }

    public Response getResponse() {
        if (this.mResponse == null) {
            this.mResponse = Response.fromValue(this.getMessage().getInt(RESPONSE));
        }
        return this.mResponse;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.createAny(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mGroupAddress;
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRfss;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getRfss());
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

