/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelGrantUpdateExplicit
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] RESERVED = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] DOWNLINK_FREQUENCY_BAND = new int[]{32, 33, 34, 35};
    private static final int[] DOWNLINK_CHANNEL_NUMBER = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] UPLINK_FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] UPLINK_CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] GROUP_ADDRESS = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private VoiceServiceOptions mVoiceServiceOptions;
    private APCO25ExplicitChannel mChannel;
    private Identifier mGroupAddress;
    private List<Identifier> mIdentifiers;

    public GroupVoiceChannelGrantUpdateExplicit(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TALKGROUP:").append(this.getGroupAddress());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" ").append(this.getVoiceServiceOptions().toString());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public APCO25ExplicitChannel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL_NUMBER), this.getMessage().getInt(UPLINK_FREQUENCY_BAND), this.getMessage().getInt(UPLINK_CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mGroupAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

