/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import java.util.ArrayList;
import java.util.List;

public class GroupDataChannelAnnouncement
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] FREQUENCY_BAND_A = new int[]{16, 17, 18, 19};
    private static final int[] CHANNEL_NUMBER_A = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] GROUP_ADDRESS_A = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND_B = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER_B = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] GROUP_ADDRESS_B = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private IChannelDescriptor mChannelA;
    private Identifier mGroupAddressA;
    private IChannelDescriptor mChannelB;
    private Identifier mGroupAddressB;
    private List<Identifier> mIdentifiers;

    public GroupDataChannelAnnouncement(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" GROUP A:").append(this.getGroupAddressA());
        sb.append(" CHAN:").append(this.getChannelA());
        sb.append(" GROUP B:").append(this.getGroupAddressB());
        sb.append(" CHAN:").append(this.getChannelB());
        return sb.toString();
    }

    public IChannelDescriptor getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_A), this.getMessage().getInt(CHANNEL_NUMBER_A));
        }
        return this.mChannelA;
    }

    public Identifier getGroupAddressA() {
        if (this.mGroupAddressA == null) {
            this.mGroupAddressA = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_A));
        }
        return this.mGroupAddressA;
    }

    public IChannelDescriptor getChannelB() {
        if (this.mChannelB == null) {
            this.mChannelB = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_B), this.getMessage().getInt(CHANNEL_NUMBER_B));
        }
        return this.mChannelB;
    }

    public Identifier getGroupAddressB() {
        if (this.mGroupAddressB == null) {
            this.mGroupAddressB = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_B));
        }
        return this.mGroupAddressB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddressA());
            this.mIdentifiers.add(this.getGroupAddressB());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        channels.add(this.getChannelB());
        return channels;
    }
}

