/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25AnnouncementTalkgroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.Response;
import java.util.ArrayList;
import java.util.List;

public class GroupAffiliationResponse
extends OSPMessage {
    private static final int GLOBAL_LOCAL_FLAG = 16;
    private static final int[] RESERVED = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] RESPONSE = new int[]{22, 23};
    private static final int[] ANNOUNCEMENT_GROUP_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] GROUP_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Response mAffiliationResponse;
    private Identifier mAnnouncementGroupAddress;
    private Identifier mGroupAddress;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public GroupAffiliationResponse(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" GROUP ADDRESS:").append(this.getGroupAddress());
        sb.append(" (").append(this.isGlobalAffiliation() ? "GLOBAL" : "LOCAL").append(")");
        sb.append(" AFFILIATION:").append((Object)this.getAffiliationResponse());
        sb.append(" ANNOUNCEMENT GROUP:").append(this.getAnnouncementGroupAddress());
        return sb.toString();
    }

    public boolean isGlobalAffiliation() {
        return this.getMessage().get(16);
    }

    public Response getAffiliationResponse() {
        if (this.mAffiliationResponse == null) {
            this.mAffiliationResponse = Response.fromValue(this.getMessage().getInt(RESPONSE));
        }
        return this.mAffiliationResponse;
    }

    public Identifier getAnnouncementGroupAddress() {
        if (this.mAnnouncementGroupAddress == null) {
            this.mAnnouncementGroupAddress = APCO25AnnouncementTalkgroup.create(this.getMessage().getInt(ANNOUNCEMENT_GROUP_ADDRESS));
        }
        return this.mAnnouncementGroupAddress;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.createAny(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mGroupAddress;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAnnouncementGroupAddress());
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

