/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class AdjacentStatusBroadcast
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] LOCATION_REGISTRATION_AREA = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int CONVENTIONAL_CHANNEL_FLAG = 24;
    private static final int SITE_FAILURE_FLAG = 25;
    private static final int VALID_INFORMATION_FLAG = 26;
    private static final int ACTIVE_NETWORK_CONNECTION_TO_RFSS_CONTROLLER_FLAG = 27;
    private static final int[] SYSTEM = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] RFSS = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SITE = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FREQUENCY_BAND = new int[]{56, 57, 58, 59};
    private static final int[] CHANNEL_NUMBER = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SYSTEM_SERVICE_CLASS = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mLocationRegistrationArea;
    private Identifier mSystem;
    private Identifier mSite;
    private Identifier mRfss;
    private IChannelDescriptor mChannel;
    private SystemServiceClass mSystemServiceClass;
    private List<Identifier> mIdentifiers;
    private List<String> mSiteFlags;

    public AdjacentStatusBroadcast(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" CHANNEL:").append(this.getChannel());
        sb.append(" LRA:").append(this.getLocationRegistrationArea());
        sb.append(" FLAGS ").append(this.getSiteFlags());
        sb.append(" SERVICES ").append(this.getSystemServiceClass());
        return sb.toString();
    }

    public List<String> getSiteFlags() {
        if (this.mSiteFlags == null) {
            this.mSiteFlags = new ArrayList<String>();
            if (this.isConventionalChannel()) {
                this.mSiteFlags.add("CONVENTIONAL CHANNEL");
            }
            if (this.isFailedConditionSite()) {
                this.mSiteFlags.add("FAILURE CONDITION");
            }
            if (this.isValidSiteInformation()) {
                this.mSiteFlags.add("VALID INFORMATION");
            }
            if (this.isActiveNetworkConnectionToRfssControllerSite()) {
                this.mSiteFlags.add("ACTIVE RFSS CONNECTION");
            }
        }
        return this.mSiteFlags;
    }

    public boolean isConventionalChannel() {
        return this.getMessage().get(24);
    }

    public boolean isFailedConditionSite() {
        return this.getMessage().get(25);
    }

    public boolean isValidSiteInformation() {
        return this.getMessage().get(26);
    }

    public boolean isActiveNetworkConnectionToRfssControllerSite() {
        return this.getMessage().get(27);
    }

    public Identifier getLocationRegistrationArea() {
        if (this.mLocationRegistrationArea == null) {
            this.mLocationRegistrationArea = APCO25Lra.create(this.getMessage().getInt(LOCATION_REGISTRATION_AREA));
        }
        return this.mLocationRegistrationArea;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRfss;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLocationRegistrationArea());
            this.mIdentifiers.add(this.getSystem());
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getRfss());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

