/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.reference.Direction;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.ArrayList;
import java.util.List;

public class AcknowledgeResponse
extends OSPMessage {
    private static final int ADDITIONAL_INFORMATION_FLAG = 16;
    private static final int EXTENDED_INFORMATION_FLAG = 17;
    private static final int[] SERVICE_TYPE = new int[]{18, 19, 20, 21, 22, 23};
    private static final int[] WACN = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] SYSTEM = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mWACN;
    private Identifier mSystemId;
    private Identifier mTargetAddress;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public AcknowledgeResponse(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.hasSourceAddress()) {
            sb.append(" FM:").append(this.getSourceAddress());
        }
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" ACKNOWLEDGING:").append((Object)this.getAcknowledgedServiceType());
        if (this.hasWACN()) {
            sb.append(" WACN:").append(this.getWACN());
        }
        if (this.hasSystem()) {
            sb.append(" SYSTEM:").append(this.getSystemId());
        }
        return sb.toString();
    }

    private boolean hasAdditionalInformation() {
        return this.getMessage().get(16);
    }

    private boolean isExtendedSystemInformation() {
        return this.getMessage().get(17);
    }

    public boolean hasWACN() {
        return this.hasAdditionalInformation() && this.isExtendedSystemInformation();
    }

    public Identifier getWACN() {
        if (this.hasWACN()) {
            if (this.mWACN == null) {
                this.mWACN = APCO25Wacn.create(this.getMessage().getInt(WACN));
            }
            return this.mWACN;
        }
        return null;
    }

    public boolean hasSystem() {
        return this.hasAdditionalInformation() && this.isExtendedSystemInformation();
    }

    public Identifier getSystemId() {
        if (this.hasSystem()) {
            if (this.mSystemId == null) {
                this.mSystemId = APCO25System.create(this.getMessage().getInt(SYSTEM));
            }
            return this.mSystemId;
        }
        return null;
    }

    public Opcode getAcknowledgedServiceType() {
        return Opcode.fromValue(this.getMessage().getInt(SERVICE_TYPE), Direction.INBOUND, Vendor.STANDARD);
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public boolean hasSourceAddress() {
        return this.hasAdditionalInformation() && !this.isExtendedSystemInformation();
    }

    public Identifier getSourceAddress() {
        if (this.hasSourceAddress()) {
            if (this.mSourceAddress == null) {
                this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
            }
            return this.mSourceAddress;
        }
        return null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            if (this.hasSourceAddress()) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
            if (this.hasWACN()) {
                this.mIdentifiers.add(this.getWACN());
            }
            if (this.hasSystem()) {
                this.mIdentifiers.add(this.getSystemId());
            }
        }
        return this.mIdentifiers;
    }
}

