/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import java.util.ArrayList;
import java.util.List;

public class PatchGroupDelete
extends OSPMessage {
    public static final int[] PATCH_GROUP_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    public static final int[] GROUP_ADDRESS_1 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    public static final int[] GROUP_ADDRESS_2 = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    public static final int[] GROUP_ADDRESS_3 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private APCO25PatchGroup mPatchGroup;
    private TalkgroupIdentifier mGroupAddress1;
    private TalkgroupIdentifier mGroupAddress2;
    private TalkgroupIdentifier mGroupAddress3;
    private List<TalkgroupIdentifier> mPatchedTalkgroups;
    private List<Identifier> mIdentifiers;

    public PatchGroupDelete(P25P1DataUnitID dataUnitID, CorrectedBinaryMessage message, int nac, long timeslot) {
        super(dataUnitID, message, nac, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" PATCH GROUP:").append(this.getPatchGroup());
        return sb.toString();
    }

    public Identifier getPatchGroup() {
        if (this.mPatchGroup == null) {
            PatchGroup patchGroup = new PatchGroup(APCO25Talkgroup.create(this.getPatchAddress()));
            patchGroup.addPatchedTalkgroups(this.getPatchedTalkgroups());
            this.mPatchGroup = APCO25PatchGroup.create(patchGroup);
        }
        return this.mPatchGroup;
    }

    private int getPatchAddress() {
        return this.getMessage().getInt(PATCH_GROUP_ADDRESS);
    }

    public List<TalkgroupIdentifier> getPatchedTalkgroups() {
        if (this.mPatchedTalkgroups == null) {
            this.mPatchedTalkgroups = new ArrayList<TalkgroupIdentifier>();
            if (this.hasAddress1()) {
                this.mPatchedTalkgroups.add(this.getGroupAddress1());
            }
            if (this.hasGroupAddress2()) {
                this.mPatchedTalkgroups.add(this.getGroupAddress2());
            }
            if (this.hasGroupAddress3()) {
                this.mPatchedTalkgroups.add(this.getGroupAddress3());
            }
        }
        return this.mPatchedTalkgroups;
    }

    public TalkgroupIdentifier getGroupAddress1() {
        if (this.mGroupAddress1 == null) {
            this.mGroupAddress1 = APCO25Talkgroup.create(this.getAddress1());
        }
        return this.mGroupAddress1;
    }

    private int getAddress1() {
        return this.getMessage().getInt(GROUP_ADDRESS_1);
    }

    private boolean hasAddress1() {
        return this.getPatchAddress() != this.getAddress1();
    }

    public TalkgroupIdentifier getGroupAddress2() {
        if (this.mGroupAddress2 == null) {
            this.mGroupAddress2 = APCO25Talkgroup.create(this.getAddress2());
        }
        return this.mGroupAddress2;
    }

    private int getAddress2() {
        return this.getMessage().getInt(GROUP_ADDRESS_2);
    }

    public boolean hasGroupAddress2() {
        return this.getPatchAddress() != this.getAddress2() && this.getAddress1() != this.getAddress2();
    }

    public TalkgroupIdentifier getGroupAddress3() {
        if (this.mGroupAddress3 == null) {
            this.mGroupAddress3 = APCO25Talkgroup.create(this.getAddress3());
        }
        return this.mGroupAddress3;
    }

    private int getAddress3() {
        return this.getMessage().getInt(GROUP_ADDRESS_3);
    }

    public boolean hasGroupAddress3() {
        return this.getPatchAddress() != this.getAddress2() && this.getAddress1() != this.getAddress3() && this.getAddress2() != this.getAddress3();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
        }
        return this.mIdentifiers;
    }
}

