/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MotorolaBaseStationId
extends OSPMessage
implements IFrequencyBandReceiver {
    public static final int[] CHARACTER_1 = new int[]{16, 17, 18, 19, 20, 21};
    public static final int[] CHARACTER_2 = new int[]{22, 23, 24, 25, 26, 27};
    public static final int[] CHARACTER_3 = new int[]{28, 29, 30, 31, 32, 33};
    public static final int[] CHARACTER_4 = new int[]{34, 35, 36, 37, 38, 39};
    public static final int[] CHARACTER_5 = new int[]{40, 41, 42, 43, 44, 45};
    public static final int[] CHARACTER_6 = new int[]{46, 47, 48, 49, 50, 51};
    public static final int[] CHARACTER_7 = new int[]{52, 53, 54, 55, 56, 57};
    public static final int[] CHARACTER_8 = new int[]{58, 59, 60, 61, 62, 63};
    public static final int[] FREQUENCY_BAND = new int[]{64, 65, 66, 67};
    public static final int[] CHANNEL_NUMBER = new int[]{68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private String mCWID;
    private IChannelDescriptor mChannel;

    public MotorolaBaseStationId(P25P1DataUnitID dataUnitID, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitID, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.hasChannel()) {
            sb.append(" CHAN:").append(this.getChannel());
            sb.append(" CWID:").append(this.getCWID());
        } else {
            sb.append(" CWID NOT SPECIFIED");
        }
        return sb.toString();
    }

    public boolean hasChannel() {
        return this.getMessage().getInt(CHANNEL_NUMBER) != 0;
    }

    public String getCWID() {
        if (this.mCWID == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCharacter(CHARACTER_1));
            sb.append(this.getCharacter(CHARACTER_2));
            sb.append(this.getCharacter(CHARACTER_3));
            sb.append(this.getCharacter(CHARACTER_4));
            sb.append(this.getCharacter(CHARACTER_5));
            sb.append(this.getCharacter(CHARACTER_6));
            sb.append(this.getCharacter(CHARACTER_7));
            sb.append(this.getCharacter(CHARACTER_8));
            this.mCWID = sb.toString();
        }
        return this.mCWID;
    }

    private String getCharacter(int[] field) {
        int value = this.getMessage().getInt(field);
        if (value != 0) {
            return String.valueOf((char)(value + 43));
        }
        return "";
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

