/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.harris.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.RegroupOptions;
import java.util.ArrayList;
import java.util.List;

public class HarrisGroupRegroupExplicitEncryptionCommand
extends OSPMessage {
    private static final int[] REGROUP_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] SUPERGROUP_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] ENCRYPTION_KEY_ID = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] TARGET_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private TalkgroupIdentifier mSuperGroupIdentifier;
    private APCO25PatchGroup mPatchGroup;
    private Identifier mPatchedIdentifier;
    private List<Identifier> mIdentifiers;
    private RegroupOptions mRegroupOptions;

    public HarrisGroupRegroupExplicitEncryptionCommand(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    public RegroupOptions getRegroupOptions() {
        if (this.mRegroupOptions == null) {
            this.mRegroupOptions = new RegroupOptions(this.getMessage().getInt(REGROUP_OPTIONS));
        }
        return this.mRegroupOptions;
    }

    public int getEncryptionKeyId() {
        return this.getMessage().getInt(ENCRYPTION_KEY_ID);
    }

    public boolean hasEncryptionKeyId() {
        return this.getEncryptionKeyId() > 0;
    }

    public APCO25PatchGroup getPatchGroup() {
        if (this.mPatchGroup == null) {
            PatchGroup patchGroup = new PatchGroup(this.getSuperGroup(), this.getRegroupOptions().getSupergroupSequenceNumber());
            Identifier identifier = this.getTargetAddress();
            if (identifier instanceof APCO25Talkgroup) {
                APCO25Talkgroup talkgroup = (APCO25Talkgroup)identifier;
                patchGroup.addPatchedTalkgroup(talkgroup);
            } else {
                identifier = this.getTargetAddress();
                if (identifier instanceof APCO25RadioIdentifier) {
                    APCO25RadioIdentifier radio = (APCO25RadioIdentifier)identifier;
                    patchGroup.addPatchedRadio(radio);
                }
            }
            this.mPatchGroup = APCO25PatchGroup.create(patchGroup);
        }
        return this.mPatchGroup;
    }

    public Identifier getTargetAddress() {
        if (this.mPatchedIdentifier == null) {
            this.mPatchedIdentifier = this.getRegroupOptions().isTalkgroupAddress() ? APCO25Talkgroup.create(this.getMessage().getInt(TARGET_ADDRESS)) : APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mPatchedIdentifier;
    }

    public TalkgroupIdentifier getSuperGroup() {
        if (this.mSuperGroupIdentifier == null) {
            this.mSuperGroupIdentifier = APCO25Talkgroup.create(this.getMessage().getInt(SUPERGROUP_ADDRESS));
        }
        return this.mSuperGroupIdentifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.getRegroupOptions().isActivate()) {
            sb.append(" ACTIVATE");
            sb.append(this.getRegroupOptions().isPatch() ? " TWO-WAY PATCH" : " ONE-WAY SIMUL-SELECT");
            sb.append(" SUPERGROUP:").append(this.getSuperGroup());
            sb.append(" V").append(this.getRegroupOptions().getSupergroupSequenceNumber());
            sb.append(" INCLUDE");
            sb.append(this.getRegroupOptions().isTalkgroupAddress() ? " TALKGROUP:" : " RADIO:");
            sb.append(this.getTargetAddress());
            if (this.hasEncryptionKeyId()) {
                sb.append(" USE ENCRYPTION KEY:").append(this.getEncryptionKeyId());
            }
        } else {
            sb.append(" DEACTIVATE SUPERGROUP:").append(this.getSuperGroup());
            sb.append(" V").append(this.getRegroupOptions().getSupergroupSequenceNumber());
        }
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
        }
        return this.mIdentifiers;
    }
}

