/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IBitErrorProvider;
import io.github.dsheirer.module.decode.p25.P25Utils;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc.UMBTCHeader;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import java.util.List;

public abstract class UMBTCMessage
extends P25Message
implements IBitErrorProvider {
    protected static final int[] HEADER_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] BLOCK_0_OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private PDUSequence mPDUSequence;

    public UMBTCMessage(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(nac, timestamp);
        this.mPDUSequence = PDUSequence2;
    }

    @Override
    protected String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessageStub());
        sb.append(" ").append((Object)this.getOpcode());
        P25Utils.pad(sb, 30);
        return sb.toString();
    }

    public UMBTCHeader getHeader() {
        return (UMBTCHeader)this.getPDUSequence().getHeader();
    }

    public Opcode getOpcode() {
        if (this.hasDataBlock(0)) {
            return Opcode.fromValue(this.getDataBlock(0).getMessage().getInt(BLOCK_0_OPCODE), this.getHeader().getDirection(), this.getHeader().getVendor());
        }
        return Opcode.OSP_UNKNOWN;
    }

    public boolean hasDataBlock(int index) {
        return this.getDataBlock(index) != null;
    }

    public UnconfirmedDataBlock getDataBlock(int index) {
        DataBlock dataBlock = this.getPDUSequence().getDataBlocks().get(index);
        if (dataBlock instanceof UnconfirmedDataBlock) {
            return (UnconfirmedDataBlock)dataBlock;
        }
        return null;
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.UNCONFIRMED_MULTI_BLOCK_TRUNKING_CONTROL;
    }

    @Override
    public abstract List<Identifier> getIdentifiers();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:").append(this.getNAC());
        if (!this.getPDUSequence().isComplete()) {
            sb.append(" *INCOMPLETE - RECEIVED ").append(this.getPDUSequence().getDataBlocks().size()).append("/").append(this.getPDUSequence().getHeader().getBlocksToFollowCount()).append(" DATA BLOCKS");
        }
        sb.append(" ").append(this.getPDUSequence().getHeader().toString());
        sb.append(" DATA BLOCKS:").append(this.getPDUSequence().getDataBlocks().size());
        if (!this.getPDUSequence().getDataBlocks().isEmpty()) {
            sb.append(" MSG:");
            for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                sb.append(dataBlock.getMessage().toHexString());
            }
        }
        return sb.toString();
    }

    public PDUSequence getPDUSequence() {
        return this.mPDUSequence;
    }

    @Override
    public int getBitsProcessedCount() {
        return this.getPDUSequence().getBitsProcessedCount();
    }

    @Override
    public int getBitErrorsCount() {
        return this.getPDUSequence().getBitErrorsCount();
    }
}

