/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.response;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequenceMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.response.ResponseHeader;
import io.github.dsheirer.module.decode.p25.reference.PacketResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResponseMessage
extends PDUSequenceMessage {
    public ResponseMessage(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    private ResponseHeader getHeader() {
        return (ResponseHeader)this.getPDUSequence().getHeader();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:").append(this.getNAC());
        sb.append(" ").append(this.getHeader().toString());
        if (this.getPDUSequence().isComplete()) {
            if (this.getHeader().getResponse() == PacketResponse.SELECTIVE_RETRY) {
                sb.append(" - RESEND BLOCKS ").append(this.getMissingBlockNumbers());
            } else if (this.getPDUSequence().getDataBlocks().size() > 0) {
                sb.append(" BLOCKS TO FOLLOW:").append(this.getPDUSequence().getDataBlocks().size());
                sb.append(" DATA BLOCKS:").append(this.getPDUSequence().getDataBlocks().size());
                if (!this.getPDUSequence().getDataBlocks().isEmpty()) {
                    sb.append(" MSG:");
                    for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                        sb.append(dataBlock.getMessage().toHexString());
                    }
                }
            }
        } else {
            sb.append(" *INCOMPLETE - RECEIVED ").append(this.getPDUSequence().getDataBlocks().size()).append("/").append(this.getHeader().getBlocksToFollowCount()).append(" DATA BLOCKS");
        }
        return sb.toString();
    }

    public List<Integer> getMissingBlockNumbers() {
        int dataBlockCount = this.getPDUSequence().getDataBlocks().size();
        if (0 < dataBlockCount && dataBlockCount <= 2) {
            ArrayList<Integer> missingBlockNumbers = new ArrayList<Integer>();
            int blockOffset = 0;
            for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                missingBlockNumbers.addAll(this.getMissingBlockNumbers(dataBlock, blockOffset));
                blockOffset += 64;
            }
            Collections.sort(missingBlockNumbers);
            return missingBlockNumbers;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Integer> getMissingBlockNumbers(DataBlock dataBlock, int offset) {
        ArrayList<Integer> missingBlockNumbers = new ArrayList<Integer>();
        int blockIndex = 7;
        BinaryMessage message = dataBlock.getMessage();
        for (int index = 0; index < 64; ++index) {
            if (!message.get(index)) {
                missingBlockNumbers.add(blockIndex + offset);
            }
            if ((--blockIndex ^ 8) != 0) continue;
            blockIndex += 8;
        }
        return missingBlockNumbers;
    }
}

