/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.response;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUHeader;
import io.github.dsheirer.module.decode.p25.reference.PacketResponse;
import io.github.dsheirer.module.decode.p25.reference.Vendor;

public class ResponseHeader
extends PDUHeader {
    public static final int[] RESPONSE = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    public static final int SOURCE_LLID_FLAG = 48;
    public static final int[] FROM_LOGICAL_LINK_ID = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};

    public ResponseHeader(CorrectedBinaryMessage message, boolean passesCRC) {
        super(message, passesCRC);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("***CRC-FAIL*** ");
        }
        sb.append("PDU   RESPONSE");
        if (this.hasSourceLLID()) {
            sb.append(" FROM:").append(this.getFromLogicalLinkID());
        }
        sb.append(" TO:").append(this.getLLID());
        sb.append(" ").append((Object)this.getResponse());
        Vendor vendor = this.getVendor();
        if (vendor != Vendor.STANDARD) {
            sb.append(" VENDOR:").append((Object)this.getVendor());
        }
        return sb.toString();
    }

    public PacketResponse getResponse() {
        return PacketResponse.fromValue(this.getMessage().getInt(RESPONSE));
    }

    public boolean hasSourceLLID() {
        return !this.getMessage().get(48);
    }

    public String getFromLogicalLinkID() {
        return this.getMessage().getHex(FROM_LOGICAL_LINK_ID, 6);
    }
}

