/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.p25.reference.IPHeaderCompression;
import io.github.dsheirer.module.decode.p25.reference.PDUType;
import io.github.dsheirer.module.decode.p25.reference.UDPHeaderCompression;

public class SNDCPPacketHeader
extends Header {
    private static final int[] PDU_TYPE = new int[]{0, 1, 2, 3};
    private static final int[] NSAPI = new int[]{4, 5, 6, 7};
    private static final int[] PACKET_HEADER_COMPRESSION = new int[]{8, 9, 10, 11};
    private static final int[] DATAGRAM_HEADER_COMPRESSION = new int[]{12, 13, 14, 15};
    private boolean mOutboundMessage;

    public SNDCPPacketHeader(BinaryMessage message, boolean outboundMessage) {
        super(message, 0);
        this.mOutboundMessage = outboundMessage;
    }

    @Override
    public int getLength() {
        return this.getMessage().size();
    }

    public SNDCPPacketHeader(boolean outboundMessage) {
        this(new BinaryMessage(0), outboundMessage);
    }

    public boolean isOutboundMessage() {
        return this.mOutboundMessage;
    }

    public boolean hasData() {
        return this.getLength() == 16;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasData()) {
            sb.append((Object)this.getPDUType());
            sb.append(" NSAPI:").append(this.getNSAPI());
            sb.append(" IP COMPRESSION:").append((Object)this.getIPHeaderCompression());
            sb.append(" UDP COMPRESSION:").append((Object)this.getUDPHeaderCompression());
        } else {
            sb.append("NO SNDCP HEADER");
        }
        return sb.toString();
    }

    public PDUType getPDUType() {
        if (this.hasData()) {
            return PDUType.fromValue(this.getMessage().getInt(PDU_TYPE), this.isOutboundMessage());
        }
        return this.isOutboundMessage() ? PDUType.OUTBOUND_UNKNOWN : PDUType.INBOUND_UNKNOWN;
    }

    public int getNSAPI() {
        return this.getMessage().getInt(NSAPI);
    }

    public IPHeaderCompression getIPHeaderCompression() {
        return IPHeaderCompression.fromValue(this.getMessage().getInt(PACKET_HEADER_COMPRESSION));
    }

    public UDPHeaderCompression getUDPHeaderCompression() {
        return UDPHeaderCompression.fromValue(this.getMessage().getInt(DATAGRAM_HEADER_COMPRESSION));
    }
}

